% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visOmopTable.R
\name{visOmopTable}
\alias{visOmopTable}
\title{Format a \verb{<summarised_result>} object into a gt, flextable, or tibble object}
\usage{
visOmopTable(
  result,
  estimateName = character(),
  header = character(),
  settingsColumn = character(),
  groupColumn = character(),
  rename = character(),
  type = "gt",
  hide = character(),
  columnOrder = character(),
  factor = list(),
  showMinCellCount = TRUE,
  .options = list()
)
}
\arguments{
\item{result}{A \verb{<summarised_result>} object.}

\item{estimateName}{A named list of estimate names to join, sorted by
computation order. Use \verb{<...>} to indicate estimate names.}

\item{header}{A vector specifying the elements to include in the header.
The order of elements matters, with the first being the topmost header.
Elements in header can be:
\itemize{
\item Any of the columns returned by \code{tableColumns(result)} to create a header
for these columns.
\item Any other input to create an overall header.
}}

\item{settingsColumn}{A character vector with the names of settings to
include in the table. To see options use \code{settingsColumns(result)}.}

\item{groupColumn}{Columns to use as group labels, to see options use
\code{tableColumns(result)}. By default, the name of the new group will be the
tidy* column names separated by ";". To specify a custom group name, use a
named list such as:
list("newGroupName" = c("variable_name", "variable_level")).

*tidy: The tidy format applied to column names replaces "_" with a space and
converts to sentence case. Use \code{rename} to customise specific column names.}

\item{rename}{A named vector to customise column names, e.g.,
c("Database name" = "cdm_name"). The function renames all column names
not specified here into a tidy* format.}

\item{type}{The desired format of the output table. See \code{tableType()} for
allowed options.}

\item{hide}{Columns to drop from the output table. By default, \code{result_id} and
\code{estimate_type} are always dropped.}

\item{columnOrder}{Character vector establishing the position of the columns
in the formatted table. Columns in either header, groupColumn, or hide will
be ignored.}

\item{factor}{A named list where names refer to columns (see available columns
in \code{tableColumns()}) and list elements are the level order of that column
to arrange the results. The column order in the list will be used for
arranging the result.}

\item{showMinCellCount}{If \code{TRUE}, suppressed estimates will be indicated with
"<\{min_cell_count\}", otherwise, the default \code{na} defined in \code{.options} will be
used.}

\item{.options}{A named list with additional formatting options.
\code{visOmopResults::tableOptions()} shows allowed arguments and their default values.}
}
\value{
A tibble, gt, or flextable object.
}
\description{
This function combines the functionalities of \code{formatEstimateValue()},
\code{estimateName()}, \code{formatHeader()}, and \code{formatTable()}
into a single function specifically for \verb{<summarised_result>} objects.
}
\examples{
result <- mockSummarisedResult()
result |>
  visOmopTable(
    estimateName = c("N\%" = "<count> (<percentage>)",
                     "N" = "<count>",
                     "Mean (SD)" = "<mean> (<sd>)"),
    header = c("group"),
    rename = c("Database name" = "cdm_name"),
    groupColumn = strataColumns(result)
  )
}
