% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_stepribbon.R
\docType{data}
\name{stat_stepribbon}
\alias{stat_stepribbon}
\alias{StatStepribbon}
\title{Step ribbon statistic}
\format{
An object of class \code{StatStepRibbon} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 3.
}
\usage{
stat_stepribbon(
  mapping = NULL,
  data = NULL,
  geom = "ribbon",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  direction = "hv",
  ...
)

StatStepribbon
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{which geom to use; defaults to "\code{ribbon}"}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{direction}{\code{hv} for horizontal-vertical steps, \code{vh} for
vertical-horizontal steps}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\value{
a ggplot
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Provides stair-step values for ribbon plots, often using in
conjunction with \code{ggplot2::geom_step()}.
The step ribbon can be added with \code{stat_stepribbon()} or
identically with \code{ggplot2::geom_ribbon(stat = "stepribbon")}
}
\examples{
# using ggplot2::geom_ribbon()
survival::survfit(survival::Surv(time, status) ~ 1, data = survival::lung) \%>\%
  survival::survfit0() \%>\%
  broom::tidy() \%>\%
  ggplot2::ggplot(ggplot2::aes(x = time, y = estimate, ymin = conf.low, ymax = conf.high)) +
  ggplot2::geom_step() +
  ggplot2::geom_ribbon(stat = "stepribbon", alpha = 0.2)

# using stat_stepribbon() with the same result
survival::survfit(survival::Surv(time, status) ~ 1, data = survival::lung) \%>\%
  survival::survfit0() \%>\%
  broom::tidy() \%>\%
  ggplot2::ggplot(ggplot2::aes(x = time, y = estimate, ymin = conf.low, ymax = conf.high)) +
  ggplot2::geom_step() +
  visR::stat_stepribbon(alpha = 0.2)
}
\references{
\url{https://groups.google.com/forum/?fromgroups=#!topic/ggplot2/9cFWHaH1CPs}
}
\keyword{datasets}
