% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_analysis.R
\name{plot.VTDEC}
\alias{plot.VTDEC}
\title{Plot decision map}
\usage{
\method{plot}{VTDEC}(x, margin = 0.003, nms = c("TT", "NME", "SE",
  "UN"), col.reg = "pink", col.prob = "blue", cex.prob = 0.9,
  cex.nms = 1, ...)
}
\arguments{
\item{x}{A class \code{VTDEC} list generated by \code{\link{vtDecMap}}}

\item{margin}{Margin between regions in the decision map}

\item{nms}{Labels of the regions on a decision map. Defaults are:
\itemize{
\item{\code{TT}:}{Too Toxic}
\item{\code{NME}:}{No More Effective}
\item{\code{SE}:}{Safe and Effective}
\item{\code{UN}:}{Uncertain}
}}

\item{col.reg}{Background color of the selected region}

\item{col.prob}{Text color of the selected region.}

\item{cex.prob}{Text size of the probabilities}

\item{cex.nms}{Text size of the region labels}

\item{...}{Optional arguments for \code{plot}.}
}
\description{
Plot a decision map based on a class \code{VTDEC} object that contains the
current posterior analysis results
}
\examples{

etas       <- c(0.1, 0.3)
dec.cut    <- c(0.6,0.6,0.6)
cur.obs.y  <- c(3, 2, 1, 1)
prev.obs.y <- c(5, 2, 0, 0)
rst.inter  <- vtInterim(cur.obs.y,  prev.obs.y = prev.obs.y,
                        prob.mdl = "NONPARA", etas = etas, dec.cut = dec.cut,
                        nsmp = 2000);
plot(rst.inter)

}
