% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_simu.R
\name{vtPriorPar}
\alias{vtPriorPar}
\title{Get prior distribution parameters}
\usage{
vtPriorPar(prior.y = NULL, tau = NULL, sdalpha = 10, sdrho = 10,
  vtheta = NULL)
}
\arguments{
\item{prior.y}{Historical data for generating prior parameters. It has the
same structure as \code{obs.y} in \code{\link{vtPost}}.}

\item{tau}{Vector of \eqn{\tau} values. See \code{\link{visit}} for details.
Can not be \code{NULL} if \code{prior.y} is \code{NULL}.}

\item{sdalpha}{\eqn{\sigma_\alpha}. See \code{\link{visit}} for details.}

\item{sdrho}{\eqn{\sigma_\rho}.}

\item{vtheta}{Additional variance term for eliciting prior parameters from
\code{prior.y}}
}
\value{
A \code{VTPRIOR} list with

\itemize{

\item{TAU:}{vector of \eqn{\tau}'s for each level}

\item{ABCD:}{A matrix of 4 columns: \eqn{a_q}, \eqn{b_q}, \eqn{a_\rho},
    \eqn{{\sigma_\rho}}. Each row represents a dose level.}}
}
\description{
Get prior distribution parameters for partially parametric or partially parametric+ models
}
\details{
The priors are specified as \eqn{q^{(l)} \sim Beta(a_q^{(l)}, b_q^{(l)})},
and \eqn{\log\rho^{(l)} \sim N(0, \sigma_\rho^2)}.
}
\examples{

par.prior <- vtPriorPar(tau = c(0.2, 0.4, 0.6), sdalpha = 10);

}
