% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vistla.R
\name{flow}
\alias{flow}
\alias{print.vistla_flow}
\title{Construct the value for the flow}
\usage{
flow(code, ..., from = TRUE, into = FALSE, down, up, forcepath)

\method{print}{vistla_flow}(x, ...)
}
\arguments{
\item{code}{Character code of the flow parameter, like \code{"fromdown"}. 
If given, overrides other arguments.}

\item{...}{ignored.}

\item{from}{if \code{TRUE}, paths must satisfy data processing inequality as going from the root.}

\item{into}{if \code{TRUE}, paths must satisfy data processing inequality as going into the root.}

\item{down}{if \code{TRUE}, subsequent features on the path must have lower mutual information with the root; by default, true when \code{from} is true but if both \code{from} and \code{into} are true.
Can't be true together with \code{up}.}

\item{up}{if \code{TRUE}, subsequent features on the path must have higher mutual information with the root; by default, true when \code{into} is true but if both \code{from} and \code{into} are true.
Can't be true together with \code{down}.}

\item{forcepath}{when neither \code{up} or \code{down} is true, vistla may output walks rather than paths, i.e., sequences of features which are not unique.
Yet, when this argument is set to \code{TRUE}, additional condition is checked to forbid such self-intersections.
One should note that this check is computationally expensive, though.
By default true when both \code{up} and \code{down} are false.}

\item{x}{flow value to print.}
}
\value{
A \code{vistla_flow} object which can be passed to the \code{vistla} function; 
 in practice, a single integer value.
}
\description{
Vistla builds the tree by optimising the influence score over path, which is given by the iota function.
The \code{flow} argument of the vistla function can be used to modify the default iota and some associated behaviours.
This function can be used to construct the proper value of this argument.
}
