% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_clustering.R
\name{compute_dmat}
\alias{compute_dmat}
\title{Compute a distance matrix from scaled data}
\usage{
compute_dmat(
  x,
  dist_method = "euclidean",
  apply_scaling = FALSE,
  subset_cols = NULL
)
}
\arguments{
\item{x}{a numeric data frame or matrix}

\item{dist_method}{a distance measure to apply to the scaled data. Must be those supported by \code{\link[stats:dist]{stats::dist()}}, plus \code{"mahalanobis"} and \code{"cosine"}. Default is \code{"euclidean"}.}

\item{apply_scaling}{use TRUE to apply \code{\link[base:scale]{base::scale()}}. By default does not scale data.}

\item{subset_cols}{(optional) a list of columns to subset the data}
}
\value{
an object of class "dist" (see \code{\link[stats:dist]{stats::dist()}})
}
\description{
This function applies scaling to the columns of a data frame and
computes and returns a distance matrix from a chosen distance measure.
}
\examples{
dmat <- compute_dmat(iris, "euclidean", TRUE, c("Petal.Length", "Sepal.Length"))
print(class(dmat))
}
