% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racusum_beta_arl.R
\name{racusum_beta_arl}
\alias{racusum_beta_arl}
\alias{racusum_beta_arl_mc}
\alias{racusum_beta_arl_int}
\alias{racusum_beta_arl_sim}
\title{ARL of Beta RA-CUSUM charts}
\usage{
racusum_beta_arl_mc(h, shape1, shape2, g0, g1, RA, RQ = 1, r = 600, method = 1)

racusum_beta_arl_int(h, shape1, shape2, g0, g1, RA, RQ, N, pw)

racusum_beta_arl_sim(h, shape1, shape2, g0, g1, r, RA = 2, RQ = 1, rs = 71)
}
\arguments{
\item{h}{Double. \code{h} is the control limit (>\code{0}).}

\item{shape1}{Double. Shape parameter \eqn{\alpha}{alpha} \code{> 0} of the beta distribution.}

\item{shape2}{Double. Shape parameter \eqn{\beta}{beta} \code{> 0} of the beta distribution.}

\item{g0}{Double. Estimated intercept coefficient from a binary logistic regression model.}

\item{g1}{Double. Estimated slope coefficient from a binary logistic regression model.}

\item{RA}{Double. Odds ratio of death under the alternative hypotheses. Detecting deterioration
in performance with increased mortality risk by doubling the odds Ratio \code{RA = 2}. Detecting
 improvement in performance with decreased mortality risk by halving the odds ratio of death
 \code{RA = 1/2}. Odds ratio of death under the null hypotheses is \code{1}.}

\item{RQ}{Double. Defines the performance of a surgeon with the odds ratio ratio of death.}

\item{r}{Integer. Number of runs.}

\item{method}{Character. If \code{method = "1"} a combination of Sequential Probability Ratio
Test and Toeplitz matrix structure is used to calculate the ARL. \code{"2"} solves a linear
equation system using the classical approach of \emph{Brook and Evans (1972)} to calculate the
ARL.}

\item{N}{Integer. Number of quadrature nodes, dimension of the resulting linear equation system
is equal to \code{N}.}

\item{pw}{Logical. If \code{FALSE} full collocation is applied. If \code{TRUE} a piece-wise
collocation method is used.}

\item{rs}{Integer. Maximum risk score.}
}
\value{
Returns a single value which is the Average Run Length for \code{"racusum_beta_arl_mc"}
and \code{"racusum_beta_arl_int"}, and the Run Length for \code{"racusum_beta_arl_sim"}.
}
\description{
Compute the ARL of risk-adjusted CUSUM charts assuming a beta distributed
patient mix.
}
\examples{
\dontrun{
library(vlad)
## Markov Chain
racusum_beta_arl_mc(h=4.5, shape1=1, shape2=6, g0=-3.6798, g1=0.0768*71, RA=2, r=1e4)
## Full collocation
racusum_beta_arl_int(h=4.5, shape1=1, shape2=6, g0=-3.6798, g1=0.0768*71, RA=2, RQ=1, N=150,
 pw=FALSE)
## Piece-wise collocation
racusum_beta_arl_int(h=4.5, shape1=1, shape2=6, g0=-3.6798, g1=0.0768*71, RA=2, RQ=1, N=49,
 pw=TRUE)
## Monte Carlo simulation
m <- 1e3
RLS <- sapply(1:m, racusum_beta_arl_sim, h=4.5, shape1=1, shape2=6, g0=-3.6798, g1=0.0768,
RA = 2, RQ = 1, rs = 71)
data.frame(cbind(ARL=mean(RLS), ARLSE=sd(RLS)/sqrt(m)))
}
}
\references{
Brook D and Evans DA (1972)
 An approach to the probability distribution of CUSUM run length.
 \emph{Biometrika}, \strong{59}(3), pp. 539--549
}
\author{
Philipp Wittenberg
}
