% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virtualbox.R
\name{virtualboxOptions}
\alias{virtualboxOptions}
\title{List 'VirtualBox' options available}
\usage{
virtualboxOptions(details = TRUE)
}
\arguments{
\item{details}{if TRUE print options (default), otherwise only return default options}
}
\value{
A default list of options

\if{html}{\out{<div class="sourceCode r">}}\preformatted{list(
gui = TRUE,
name = NULL,
nic_type = NULL,
linked_clone = FALSE,
check_guest_additions = TRUE,
modifyvm = list(cpus = "2", memory = "4096")
)
}\if{html}{\out{</div>}}
}
\description{
List available options for 'VirtualBox' provider
}
\details{
Get the 'VirtualBox' default options.
It return a list as follow:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{list(
gui = TRUE,
name = NULL,
nic_type = NULL,
linked_clone = FALSE,
check_guest_additions = TRUE,
modifyvm = list(cpus = "2", memory = "4096")
)
}\if{html}{\out{</div>}}
\itemize{
\item \strong{gui}: if TRUE show the GUI, otherwise headless mode is actived
\item \strong{name}: the 'VirtualBox' instance name
\item \strong{nic_type}: the NIC type for the network interface to use, by default use the default one.
see \href{https://www.virtualbox.org/manual/ch06.html}{VirtualBox Networking}
\item \strong{linked_clone}: if TRUE, linked clones are based on a master VM, which is
generated by importing the base box only once the first time it is required.
For the linked clones only differencing disk images are created where
the parent disk image belongs to the master VM.
(Be careful, master VM can't be remove until linked_clone still exists)
\item \strong{check_guest_additions}: If TRUE (default) check if guest have guest additions installed.
\item \strong{modifyvm}: list of 'VirtualBox' properties for the guest VM (such as number of cpus, memory size,...).
\href{https://www.virtualbox.org/manual/ch08.html#vboxmanage-modifyvm}{see 'VirtualBox' modifyvm}
}
}
\examples{
\dontrun{
vb.opts <- virtualboxOptions(details = FALSE)
vb.opts$modifyvm$cpus <- "4"
vb.opts$modifyvm$memory <- "8192"
vb.opts
}
}
