% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heemod.R
\name{import_heemod}
\alias{import_heemod}
\alias{import_heemod_outputs}
\alias{import_heemod_inputs}
\title{Import results of probabilistic analysis from heemod}
\usage{
import_heemod_outputs(obj, k = NULL)

import_heemod_inputs(obj)
}
\arguments{
\item{obj}{Object returned by the \code{\link[heemod]{run_psa}}
function in \pkg{heemod}, containing samples from probabilistic
analysis of a decision model.}

\item{k}{Vector of willingness-to-pay values.  The default is
inherited from the \code{\link[BCEA]{bcea}} function from the \pkg{BCEA}
package.}
}
\value{
\code{import_heemod_outputs} produces a list of model
outputs in "cost-effectiveness analysis" format, that can be
supplied as the \code{outputs} argument to \code{\link{evppi}}
and similar functions in the \pkg{voi} package.  Both the
\pkg{heemod} and \pkg{BCEA} packages need to be installed to use
this.

\code{import_heemod_inputs} produces a data frame with samples of
parameter values under uncertainty, that can be supplied as the
\code{inputs} argument to \code{\link{evppi}} and similar functions
in \pkg{voi}.
}
\description{
\href{https://CRAN.R-project.org/package=heemod}{heemod} is a package
for constructing common forms of health economic decision models.
The outputs from probabilistic analysis of these models can be
imported using these functions, to allow Value of Information
measures to be calculated for them using the \pkg{voi} package.
}
