% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_samp.rate.R
\name{get_samp.rate}
\alias{get_samp.rate}
\title{Get sample rate}
\usage{
get_samp.rate(x)
}
\arguments{
\item{x}{Wave object from `tuneR::readWave`.}
}
\value{
An integer scalar indicating the sample rate from a WAV file.
}
\description{
Get sample rate from WAV file.
}
\examples{
library(voice)

# get path to audio file
path2wav <- list.files(system.file('extdata', package = 'wrassp'),
pattern <- glob2rx('*.wav'), full.names = TRUE)

rw <- tuneR::readWave(path2wav[1])
voice::get_samp.rate(rw)

rwl <- lapply(path2wav, tuneR::readWave)
sapply(rwl, voice::get_samp.rate)
}
