% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitw.R
\name{splitw}
\alias{splitw}
\title{Split Wave}
\usage{
splitw(
  fromWav,
  fromRttm = NULL,
  toSplit = NULL,
  autoDir = FALSE,
  subDir = FALSE,
  output = "wave",
  filesRange = NULL,
  full.names = TRUE,
  recursive = FALSE,
  silence.gap = 0.5
)
}
\arguments{
\item{fromWav}{Either WAV file or directory containing WAV files.}

\item{fromRttm}{Either RTTM file or directory containing RTTM files. Default: \code{NULL}.}

\item{toSplit}{A directory to write generated files. Default: \code{NULL}.}

\item{autoDir}{Logical. Must the directories tree be created? Default: \code{FALSE}. See 'Details'.}

\item{subDir}{Logical. Must the splitted files be placed in subdirectories? Default: \code{FALSE}.}

\item{output}{Character string, the class of the object to return, either 'wave' or 'list'.}

\item{filesRange}{The desired range of directory files (default: \code{NULL}, i.e., all files). Must be TRUE only if \code{fromWav} is a directory.}

\item{full.names}{Logical. If \code{TRUE}, the directory path is prepended to the file names to give a relative file path. If \code{FALSE}, the file names (rather than paths) are returned. (default: \code{TRUE}) Used by \code{base::list.files}.}

\item{recursive}{Logical. Should the listing recursively into directories? (default: \code{FALSE}) Used by \code{base::list.files}. Inactive if \code{fromWav} is a file.}

\item{silence.gap}{The silence gap (in seconds) between adjacent words in a keyword. Rows with \code{tdur <= silence.gap} are removed. (default: \code{0.5})}
}
\value{
Splited audio files according to the correspondent RTTM file(s). See '\code{voice::diarize}'.
}
\description{
Split WAV files either in \code{fromWav} directory or using (same names) RTTM files/subdirectories as guidance.
}
\details{
When \code{autoDir = TRUE}, the following directories are created: \code{'../mp3'},\code{'../rttm'}, \code{'../split'} and \code{'../musicxml'}. Use \code{getwd()} to find the parent directory \code{'../'}.
}
\examples{
\dontrun{
library(voice)

urlWav <- 'https://raw.githubusercontent.com/filipezabala/voiceAudios/main/wav/sherlock0.wav'
destWav <- paste0(tempdir(), '/sherlock0.wav')
download.file(urlWav, destfile = destWav)

urlRttm <- 'https://raw.githubusercontent.com/filipezabala/voiceAudios/main/rttm/sherlock0.rttm'
destRttm <- paste0(tempdir(), '/sherlock0.rttm')
download.file(urlRttm, destfile = destRttm)

splitDir <- paste0(tempdir(), '/split')
dir.create(splitDir)
splitw(destWav, fromRttm = destRttm, toSplit = splitDir)

dir(splitDir)
}
}
\seealso{
\code{voice::diarize}
}
