% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nexrad_station_file.R
\name{nexrad_station_file}
\alias{nexrad_station_file}
\title{Retrieve or set the nexrad location file}
\usage{
nexrad_station_file(file)
}
\arguments{
\item{file}{A string containing the path of a location file. Do not specify to retrieve path of current location file.}
}
\value{
The path of the nexrad location file
}
\description{
Retrieves and sets the path of the RSL nexrad location file
}
\details{
The RSL library stores the locations and names of NEXRAD stations in a fixed-width
text file. This function retrieves the path of the location file, and allows one to set
the path to a different location file.
}
\examples{
# return current location file
nexrad_station_file()
# store nexrad station file path
file_path <- nexrad_station_file()
# set station location file
nexrad_station_file(file_path)

}
