% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.R
\name{plotLayers}
\alias{plotLayers}
\title{Plotting 3D model in 2D}
\usage{
plotLayers(
  rast,
  land = NA,
  landCol = "black",
  title = NULL,
  graticule = TRUE,
  ...
)
}
\arguments{
\item{rast}{A \code{SpatRaster} vector with the 3D presence/absence
distribution of a species (interpreted as 1 = presence,
0 = absence).}

\item{land}{An optional coastline polygon shapefile
of types \code{sf} or \code{SpatRaster} to provide geographic
context for the occurrence points.}

\item{landCol}{Color for land on map.}

\item{title}{A title for the plot. If not title is
supplied, the title "Suitability from (MINIMUM
DEPTH) to (MAXIMUM DEPTH)" is inferred from
names of \code{rast}.}

\item{graticule}{Do you want a grid of lon/lat lines?}

\item{...}{Additional optional arguments.}
}
\value{
A plot of class \code{recordedplot}
}
\description{
This script plots a semitransparent layer
of suitable habitat for each depth layer. The redder
the color, the shallower the layer, the bluer, the
deeper. The more saturated the color, the more layers
with suitable habitat.
}
\note{
Only include the depth layers that you actually
want to plot.
}
\examples{
library(terra)

rast1 <- rast(ncol=10, nrow=10)
values(rast1) <- rep(0:1, 50)

rast2 <- rast(ncol=10, nrow=10)
values(rast2) <- c(rep(0, 50), rep(1,50))

rast3 <- rast(ncol=10, nrow=10)
values(rast3) <- rep(c(1,0,0,1), 25)

distBrick <- c(rast1, rast2, rast3)

plotLayers(distBrick)

}
\seealso{
\code{\link[viridisLite:viridis]{viridis}}
}
\keyword{plotting}
