% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Merge.R, R/wrappers.R
\name{MergeFiles}
\alias{MergeFiles}
\alias{merge_files}
\title{Merge collected data files}
\usage{
MergeFiles(
  path = ".",
  pattern = "(?-i).+?\\\\.rds$",
  unique = TRUE,
  rev = TRUE,
  writeToFile = FALSE,
  verbose = FALSE
)

merge_files(
  path = ".",
  pattern = "(?-i).+?\\\\.rds$",
  unique = TRUE,
  rev = TRUE,
  writeToFile = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{path}{Directory path of Collect data to merge. Default is the working directory.}

\item{pattern}{Regular expression (regex) for matching file names to merge.}

\item{unique}{Logical. Remove duplicates based on observation id. Default is \code{TRUE}.}

\item{rev}{Logical. Reverses order of observations before removing duplicates. If collect data is provided
chronologically then this should ensure the most recent copy of a duplicate is kept. Default is \code{TRUE}.}

\item{writeToFile}{Logical. Save data to a file in the current working directory. Default is \code{FALSE}.}

\item{verbose}{Logical. Output additional information. Default is \code{FALSE}.}
}
\value{
A merged Collect object.
}
\description{
Merge collected data files
}
