/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Stack;
import java.util.Vector;

class Parser {
    public String text;
    public int text_index;
    char current_char;
    int last_text_index;
    char last_char;
    public Evaluator evaluator;
    static String single_quote_chars = "'\u00b4'";
    static String breaking_chars = " \r\n\t\\";
    static String white_characters = " \t\r\n\f";
    static String comment_end = "*)";
    static String[] standard_parts = new String[]{"Capital", "Script", "Gothic", "Not", "DoubleStruck", "Doubled", "Double", "Filled", "Left", "Right", ""};
    static String[] standard_short_parts = new String[]{"c", "s", "g", "n", "t", "v", "w", "f", "l", "r"};
    static String coded_char_names = "0AA225AB257AC259AD228AE230AG224AH226Ak63272Ale8501AliasD63332AliasI63336Alig63328Alp945Alt63441Andy63273And8743Angl8736Angs8491AR229As8944AT227AutoL62376AutoO62382AutoP62372AutoR62377AutoS62381Ba8726Bec8757Beta946Bet8502Br774Bu8226CAc263Cap8994cAA193cAB256cAC258cAD196cAE198cAG192cAH194cAl913cAR197cAT195cB914cCA262cCC199cCH268cCh935cDe916cDif63307cDig988cEA201cEB274cEC276cED203cEG200cEH202cEp917cEta919cEth208cG915cIA205cIC300cID207cIG204cIH206cIo921cKa922cKo990cLa923cLS321cM924cNT209cNu925cOA211cODoubleA336cODoubleD214cOG210cOH212cOme937cOmi927cOS216cOT213cPh934cPi928cPs936cR929cSa992cSH352cSi931cSt986cTa932cThe920cTho222cUA218cUDoubleA368cUDoubleD220cUG217cUH219cUp933cX926cY221cZ918CC231Ced807CenterD183CenterE8943Cent162CH269Ch967CircleD8857CircleM8854CircleP8853CircleT8855Cloc8754CloseCurlyD8221CloseCurlyQ8217Clov8984Clu9827Col8758Com63338Cong8801Conti62385Conto8750Contr63331Copr8720Copy169Cou8755Cr62624CupC8781Cup8995CurlyCapitalU978CurlyE603CurlyK1008CurlyPh981CurlyPi982CurlyR1009CurlyT977Curr164Dag8224Dal8504Das8211Deg176Dele63440Delt948Del8711Des8945Diame62468Diamond62753DiamondS9826Dif63308Dig63249Div247DotE8784DotlessI305DotlessJ63232Dott63313wC8751wDa8225vG63306wDot776wDow8659vP63305wlA8656wlr8660wlT62467wLongLeftA62720wLongLeftR62722wLongRightA62721wP8243wrA8658wrT8872tA63206tB63207tC63208tcA63396tcB63397tcC63398tcD63399tcE63400tcF63401tcG63402tcH63403tcI63404tcJ63405tcK63406tcL63407tcM63408tcN63409tcO63410tcP63411tcQ63412tcR63413tcS63414tcT63415tcU63416tcV63417tcW63418tcX63419tcY63420tcZ63421tD63209tE63210tF63211tG63212tH63213tI63214tJ63215tK63216tL63217tM63218tN63219tO63220tP63221tQ63222tR63223tS63224tT63225tU63226tV63227tW63228tX63229tY63230tZ63231wUpA8657wUpD8661wV8741DownArrowB62724DownArrowU62726DownArrow8595DownB785DownE161DownLeftR62731DownLeftT62734DownLeftVectorB62732DownLeftVector8637DownQ191DownRightT62735DownRightVectorB62733DownRightVector8641DownTeeA8615DownTee8868EA233EB275EC277ED235EG232EH234Ele8712Ell8230EmptyC9675EmptyDi9671EmptyDo9661EmptyR9647EmptySe8709EmptySmallC9702EmptySmallS62759EmptySq9635EmptyU9651EmptyV62768En63444Ep949EqualT8770Equal62513Equi8652Er63335Es63337Eta951Eth240Exi8707Exp63309Fe63274Fi63233fC9679fDi9670fDo9660fR9646fSmallC63312fSmallS62760fS9634fU9650fV62761Fin962Fiv9733Fla9837FlL63234Flo402Fo8704Fr63265Ga947Gi8503gA63180gB63181gC63182gcA63370gcB63371gcC63372gcD63373gcE63374gcF63375gcG63376gcH63377gcI63378gcJ63379gcK63380gcL63381gcM63382gcN63383gcO63384gcP63385gcQ63386gcR63387gcS63388gcT63389gcU63390gcV63391gcW63392gcX63393gcY63394gcZ63395gD63183gE63184gF63185gG63186gH63187gI63188gJ63189gK63190gL63191gM63192gN63193gO63194gP63195gQ63196gR63197gS63198gT63199gU63200gV63201gW63202gX63203gY63204gZ63205GrayC63315GrayS63314GreaterEqualL8923GreaterEqual8805GreaterF8807GreaterG8811GreaterL8823GreaterS62502GreaterT8819Hac780Hap9786HB8463He9825Ho62977HumpD8782HumpE8783Hy173IA237IC301ID239IG236IH238ImaginaryI63310ImaginaryJ63311Imp62755Ind62371Inf8734Integ8747Inter8898InvisibleC63333InvisiblePo62388InvisiblePr62387InvisibleS62304Io953Ka954Ker63318Key63443Ko63250La955lAn9001lArrowB8676lArrowR8646lArrow8592lB62979lC8968lwBracketi62981lwBracket12314lDownT62745lDownVectorB62743lDownVector8643lF8970lG171lM63339lrA8596lrV62725lS63329lTeeA8612lTeeV62729lTee8867lTriangleB62480lTriangleE8884lTriangle8882lUpD62741lUpT62744lUpVectorB62742lUpVector8639lVectorB62727lVector8636LessEqualG8922LessEqual8804LessF8806LessG8822LessL8810LessS62496LessT8818Li63267LongD8212LongLeftA62748LongLeftR62750LongR62749LowerL8601LowerR8600LS322Ma63319Mea8737Med62308Mh8487Mic181Min8723Mo63446Mu956Na9838NegativeM62339NegativeThic62340NegativeThin62338NegativeV62336NestedG62501NestedL62497Neu63266NoB62370Non160nCo8802nCu8813nw8742nEl8713nEqualT62464nEqual8800nEx8708nGreaterE8817nGreaterF8809nGreaterG62503nGreaterL8825nGreaterS62505nGreaterT8821nGreater8815nHumpD62466nHumpE62465nlTriangleB62482nlTriangleE8940nlTriangle8938nLessE8816nLessF8808nLessG8824nLessL62498nLessS62500nLessT8820nLess8814nNestedG62504nNestedL62499nPrecedesE8928nPrecedesS62507nPrecedesT8936nPrecedes8832nRe8716nrTriangleB62483nrTriangleE8941nrTriangle8939nSquareSubsetE8930nSquareSubset62510nSquareSupersetE8931nSquareSuperset62511nSubsetE8840nSubset8836nSucceedsE8929nSucceedsS62509nSucceedsT8937nSucceeds8833nSupersetE8841nSuperset8837nTildeE8772nTildeF8775nTildeT8777nTilde8769nV8740NT241Nul62368Num63268Nu957OA243ODoubleA337ODoubleD246OG242OH244Ome969Omi959OpenCurlyD8220OpenCurlyQ8216Opt63442Or8744OS248OT245OverBrace62994OverBrack62996OverP62992Para182Part8706Ph966Pi960Pla9633Plu177PrecedesE8828PrecedesS62506PrecedesT8830Precedes8826Pri8242Prod8719Proportiona8733Proportion8759Ps968Reg174ReturnI8629ReturnK63334ReverseD8245ReverseEl8715ReverseEq8651ReverseP8244ReverseU62747Rh961rAngleB9002rAngle8735rArrowB8677rArrowL8644rArrow8594rB62980rC8969rwBracketi62982rwBracket12315rDownT62740rDownVectorB62738rDownVector8642rF8971rG187rM63340rS63330rTeeA8614rTeeV62730rTee8866rTriangleB62481rTriangleE8885rTriangle8883rUpD62736rUpT62739rUpVectorB62737rUpVector8638rVectorB62728rVector8640RoundI62756RoundS62386RuleD62751Rule62754Sad9785Sam63251sA63154sB63155sC63156scA63344scB63345scC63346scD63347scE63348scF63349scG63350scH63351scI63352scJ63353scK63354scL63355scM63356scN63357scO63358scP63359scQ63360scR63361scS63362scT63363scU63364scV63365scW63366scX63367scY63368scZ63369sDotlessI63280sDotlessJ63281sD63157sE63158sF63159sG63160sH63161sI63162sJ63163sK63164sL63165sM63166sN63167sO63168sP63169sQ63170sR63171sS63172sT63173sU63174sV63175sW63176sX63177sY63178sZ63179Sec167Sel9632SH353Sha9839Shi63445ShortD62763ShortL62758ShortR62757ShortU62762Sig963Six63317Sk8259Sm8728SpaceI9251SpaceK63423Spa9824Sp8738Sqr8730SquareI8851SquareSubsetE8849SquareSubset8847SquareSupersetE8850SquareSuperset8848SquareU8852Square62752Sta8902Ste163Sti63248SubsetE8838Subset8834SucceedsE8829SucceedsS62508SucceedsT8831Succeeds8827Such8717Sum8721SupersetE8839Superset8835SZ223Tab63422Tau964Ther8756Thet952Thick62309Thin62307Tho254TildeE8771TildeF8773TildeT8776Tilde8764Tim215Tra63270Tri8411UA250UDoubleA369UDoubleD252UG249UH251UnderBrace62995UnderBrack62997UnderP62993UnionP8846Union8899Unk65533UpArrowB62723UpArrowD8645UpArrow8593UpD8597UpE62746UpperL8598UpperR8599Ups965UpTeeA8613UpTee8869Vee8897VerticalB8739VerticalE8942VerticalL62978VerticalS62514VerticalT8768Very62305Vi63271War63269Wat63316Wed8896Wei8472Wo63264Xi958YA253YD255Ye165Ze950   ";
    static boolean[] isletter0to370 = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, true, false, false, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, true, false, true, false, true, false, true, false, false, true, false, true, false, false, false, false, true, true, false, false, false, false, true, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, false, true, true, true, true, false, false, true, true, false, false, false, false, true, true, false, false, false, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false};
    static boolean[] isletter774to1009 = new boolean[]{true, false, false, false, false, false, true, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, false, false, true, true, false, false, false, true, false, true, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true};
    static boolean[] isletter8211to8504 = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, true, false, false, false, false, false, false, false, false, false, true, true, true, true};
    static boolean[] isletter8706to8738 = new boolean[]{true, false, false, true, false, true, false, false, false, false, false, false, false, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true};
    static boolean[] isletter9634to9839 = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, true, true, false, false, true, true, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, true, true, false, false, false, true, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, false, false, false, false, false, false, false, false, false, true, true, true};
    static boolean[] isletter62977to63421 = new boolean[]{true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    double scanned_real;
    boolean is_scanned_real;
    public static final int TOKEN_COMMA = 0;
    public static final int TOKEN_LEFT_PARENTHESIS = 1;
    public static final int TOKEN_RIGHT_PARENTHESIS = 2;
    public static final int TOKEN_LEFT_BRACKET = 3;
    public static final int TOKEN_RIGHT_BRACKET = 4;
    public static final int TOKEN_LEFT_BRACE = 5;
    public static final int TOKEN_RIGHT_BRACE = 6;
    public static final int TOKEN_PLUS = 7;
    public static final int TOKEN_MINUS = 8;
    public static final int TOKEN_TIMES = 9;
    public static final int TOKEN_DIVIDE = 10;
    public static final int TOKEN_POWER = 11;
    public static final int TOKEN_FACTORIAL = 12;
    public static final int TOKEN_FACTORIAL2 = 13;
    public static final int TOKEN_EQUAL = 14;
    public static final int TOKEN_UNEQUAL = 15;
    public static final int TOKEN_LESS = 16;
    public static final int TOKEN_GREATER = 17;
    public static final int TOKEN_LESSEQUAL = 18;
    public static final int TOKEN_GREATEREQUAL = 19;
    public static final int TOKEN_RIGHT_ARROW = 20;
    public static final int TOKEN_IDENTIFIER = 21;
    public static final int TOKEN_NUMBER = 22;
    public static final int TOKEN_STRING = 23;
    public static final int TOKEN_TERMINATE = 24;
    public static final int TOKEN_NONE = 25;
    public static final int TOKEN_VOID = 26;
    public static final int TOKEN_UNARY_PLUS = 27;
    public static final int TOKEN_UNARY_MINUS = 28;
    public static final int TOKEN_INVALID_IDENTIFIER = 29;
    public static final int TOKEN_FUNCTION_IDENTIFIER = 30;
    public static final int TOKEN_INEQUALITY = 31;
    public static final int TOKEN_AND = 32;
    public static final int TOKEN_OR = 33;
    public static final int TOKEN_NOT = 34;
    public static final int TOKEN_SEMICOLON = 35;
    public static final int TOKEN_SET = 36;
    static String structure_characters = ",()[]{}";
    static String number_start = "+-.0123456789";
    static String digit_characters = "0123456789";
    static String octal_digits = "01234567";
    static String hexadecimal_digits = "0123456789abcdefABCDEF";
    int scanned_token_type;
    double scanned_number;
    String scanned_identifier;
    String scanned_string;
    int scanned_function_identifier;
    static int max_length_identifier = 100;
    char[] scanned_identifier_chars = new char[max_length_identifier];
    boolean scanned_left_bracket;
    boolean is_scanning_expression = false;
    boolean is_scanning_after_operand = false;
    public static int CONSTRUCT_NONE = 0;
    public static int CONSTRUCT_FUNCTION = 1;
    public static int CONSTRUCT_SYMBOL = 2;
    public static int CONSTRUCT_LIST = 3;
    public static int CONSTRUCT_RULE = 4;
    public static int CONSTRUCT_UNIDENTIFIED = 5;
    static String name_ShowAnimation = "ShowAnimation";
    static String name_Animate = "Animate";
    static String name_AnimationDisplayTime = "AnimationDisplayTime";
    static String name_AnimationDirection = "AnimationDirection";
    static String name_Forward = "Forward";
    static String name_Backward = "Backward";
    static String name_ForwardBackward = "ForwardBackward";
    static String name_Graphics3D = "Graphics3D";
    static String name_If = "If";
    static String name_Scaled = "Scaled";
    static String name_Cuboid = "Cuboid";
    static String name_Line = "Line";
    static String name_Point = "Point";
    static String name_Polygon = "Polygon";
    static String name_Text = "Text";
    static String name_StyleForm = "StyleForm";
    static String name_Questionmark = "?";
    static String name_TextStyle = "TextStyle";
    static String name_FontWeight = "FontWeight";
    static String name_Bold = "Bold";
    static String name_FontSize = "FontSize";
    static String name_FontSlant = "FontSlant";
    static String name_Italic = "Italic";
    static String name_FontFamily = "FontFamily";
    static String name_FontColor = "FontColor";
    static String name_URL = "URL";
    static String name_FontSubstitutions = "FontSubstitutions";
    static String name_ScriptSizeMultipliers = "ScriptSizeMultipliers";
    static String name_ScriptMinSize = "ScriptMinSize";
    static String name_ScriptBaselineShifts = "ScriptBaselineShifts";
    static String name_HoldForm = "HoldForm";
    static String name_SequenceForm = "SequenceForm";
    static String name_StringForm = "StringForm";
    static String name_Subscript = "Subscript";
    static String name_Superscript = "Superscript";
    static String name_Subsuperscript = "Subsuperscript";
    static String name_Underscript = "Underscript";
    static String name_Overscript = "Overscript";
    static String name_Underoverscript = "Underoverscript";
    static String name_UnderBar = "UnderBar";
    static String name_OverBar = "OverBar";
    static String name_OverVector = "OverVector";
    static String name_OverDot = "OverDot";
    static String name_OverTilde = "OverTilde";
    static String name_OverHat = "OverHat";
    static String named_character_Dash = "\u2013";
    static String named_character_RightArrow = "\u2192";
    static String named_character_CenterDot = "\u00b7";
    static String named_character_RawTilde = "~";
    static String named_character_RawWedge = "^";
    static String name_AbsolutePointSize = "AbsolutePointSize";
    static String name_AbsoluteThickness = "AbsoluteThickness";
    static String name_CMYKColor = "CMYKColor";
    static String name_EdgeForm = "EdgeForm";
    static String name_FaceForm = "FaceForm";
    static String name_GrayLevel = "GrayLevel";
    static String name_Hue = "Hue";
    static String name_PointSize = "PointSize";
    static String name_RGBColor = "RGBColor";
    static String name_SurfaceColor = "SurfaceColor";
    static String name_Thickness = "Thickness";
    static String name_AmbientLight = "AmbientLight";
    static String name_Axes = "Axes";
    static String name_AxesLabel = "AxesLabel";
    static String name_AxesEdge = "AxesEdge";
    static String name_AxesStyle = "AxesStyle";
    static String name_PlotLabel = "PlotLabel";
    static String name_Background = "Background";
    static String name_Boxed = "Boxed";
    static String name_BoxRatios = "BoxRatios";
    static String name_BoxStyle = "BoxStyle";
    static String name_DefaultColor = "DefaultColor";
    static String name_Lighting = "Lighting";
    static String name_LightSources = "LightSources";
    static String name_PlotRange = "PlotRange";
    static String name_Ticks = "Ticks";
    static String name_ViewPoint = "ViewPoint";
    static String name_ViewVertical = "ViewVertical";
    static String name_True = "True";
    static String name_False = "False";
    static String name_Automatic = "Automatic";
    static String name_All = "All";
    static String name_None = "None";
    static String name_Catalan = "Catalan";
    static String name_Degree = "Degree";
    static String name_E = "E";
    static String name_EulerGamma = "EulerGamma";
    static String name_Glaisher = "Glaisher";
    static String name_GoldenRatio = "GoldenRatio";
    static String name_Khinchin = "Khinchin";
    static String name_Pi = "Pi";
    static String name_I = "I";
    static String name_Infinity = "Infinity";
    static String name_Indeterminate = "Indeterminate";
    static String name_ComplexInfinity = "ComplexInfinity";
    static final int FUNCTION_N = 0;
    static final int FUNCTION_PLUS = 1;
    static final int FUNCTION_SUBTRACT = 2;
    static final int FUNCTION_MINUS = 3;
    static final int FUNCTION_TIMES = 4;
    static final int FUNCTION_DIVIDE = 5;
    static final int FUNCTION_POWER = 6;
    static final int FUNCTION_ABS = 7;
    static final int FUNCTION_SIGN = 8;
    static final int FUNCTION_ROUND = 9;
    static final int FUNCTION_INTEGERPART = 10;
    static final int FUNCTION_FRACTIONALPART = 11;
    static final int FUNCTION_FLOOR = 12;
    static final int FUNCTION_CEILING = 13;
    static final int FUNCTION_CHOP = 14;
    static final int FUNCTION_MAX = 15;
    static final int FUNCTION_MIN = 16;
    static final int FUNCTION_RE = 17;
    static final int FUNCTION_IM = 18;
    static final int FUNCTION_CONJUGATE = 19;
    static final int FUNCTION_ARG = 20;
    static final int FUNCTION_MOD = 21;
    static final int FUNCTION_QUOTIENT = 22;
    static final int FUNCTION_RANDOM = 23;
    static final int FUNCTION_SEEDRANDOM = 24;
    static final int FUNCTION_LOG = 25;
    static final int FUNCTION_EXP = 26;
    static final int FUNCTION_SQRT = 27;
    static final int FUNCTION_SIN = 28;
    static final int FUNCTION_COS = 29;
    static final int FUNCTION_TAN = 30;
    static final int FUNCTION_CSC = 31;
    static final int FUNCTION_SEC = 32;
    static final int FUNCTION_COT = 33;
    static final int FUNCTION_ARCSIN = 34;
    static final int FUNCTION_ARCCOS = 35;
    static final int FUNCTION_ARCTAN = 36;
    static final int FUNCTION_ARCCSC = 37;
    static final int FUNCTION_ARCSEC = 38;
    static final int FUNCTION_ARCCOT = 39;
    static final int FUNCTION_SINH = 40;
    static final int FUNCTION_COSH = 41;
    static final int FUNCTION_TANH = 42;
    static final int FUNCTION_CSCH = 43;
    static final int FUNCTION_SECH = 44;
    static final int FUNCTION_COTH = 45;
    static final int FUNCTION_ARCSINH = 46;
    static final int FUNCTION_ARCCOSH = 47;
    static final int FUNCTION_ARCTANH = 48;
    static final int FUNCTION_ARCCSCH = 49;
    static final int FUNCTION_ARCSECH = 50;
    static final int FUNCTION_ARCCOTH = 51;
    static final int FUNCTION_FACTORIAL = 52;
    static final int FUNCTION_FACTORIAL2 = 53;
    static final int FUNCTION_BINOMIAL = 54;
    static final int FUNCTION_MULTINOMIAL = 55;
    static final int FUNCTION_POCHHAMMER = 56;
    static final int FUNCTION_GAMMA = 57;
    static final int FUNCTION_LOGGAMMA = 58;
    static final int FUNCTION_POWERMOD = 59;
    static final int FUNCTION_ERF = 60;
    static final int FUNCTION_ERFC = 61;
    static final int FUNCTION_ERFI = 62;
    static final int FUNCTION_RATIONALIZE = 63;
    static final int FUNCTION_EQUAL = 64;
    static final int FUNCTION_UNEQUAL = 65;
    static final int FUNCTION_LESS = 66;
    static final int FUNCTION_GREATER = 67;
    static final int FUNCTION_LESSEQUAL = 68;
    static final int FUNCTION_GREATEREQUAL = 69;
    static final int FUNCTION_NUMBERQ = 70;
    static final int FUNCTION_NUMERICQ = 71;
    static final int FUNCTION_INTEGERQ = 72;
    static final int FUNCTION_EVENQ = 73;
    static final int FUNCTION_ODDQ = 74;
    static final int FUNCTION_POSITIVE = 75;
    static final int FUNCTION_NEGATIVE = 76;
    static final int FUNCTION_NONPOSITIVE = 77;
    static final int FUNCTION_NONNEGATIVE = 78;
    static final int FUNCTION_TRUEQ = 79;
    static final int FUNCTION_VALUEQ = 80;
    static final int FUNCTION_NOT = 81;
    static final int FUNCTION_AND = 82;
    static final int FUNCTION_OR = 83;
    static final int FUNCTION_XOR = 84;
    static final int FUNCTION_IMPLIES = 85;
    static final int FUNCTION_IF = 86;
    static final int FUNCTION_WHICH = 87;
    static final int FUNCTION_SWITCH = 88;
    static final int FUNCTION_IDENTITY = 89;
    static final int FUNCTION_EVALUATE = 90;
    static final int FUNCTION_HOLD = 91;
    static final int FUNCTION_HOLDCOMPLETE = 92;
    static final int FUNCTION_HOLDFORM = 93;
    static final int FUNCTION_RELEASEHOLD = 94;
    static final int FUNCTION_NUMBERFORM = 95;
    static final int FUNCTION_SCIENTIFICFORM = 96;
    static final int FUNCTION_ENGINEERINGFORM = 97;
    static final int FUNCTION_ACCOUNTINGFORM = 98;
    static final int FUNCTION_PADDEDFORM = 99;
    static final int FUNCTION_STANDARDFORM = 100;
    static final int FUNCTION_TRADITIONALFORM = 101;
    static final int FUNCTION_INPUTFORM = 102;
    static final int FUNCTION_OUTPUTFORM = 103;
    static final int FUNCTION_DISPLAYFORM = 104;
    static final int FUNCTION_FULLFORM = 105;
    static final int FUNCTION_SESSIONTIME = 106;
    static final int FUNCTION_TIMEUSED = 107;
    static final int FUNCTION_ABSOLUTETIME = 108;
    static final int FUNCTION_DISCRETEDELTA = 109;
    static final int FUNCTION_KRONECKERDELTA = 110;
    static final int FUNCTION_UNITSTEP = 111;
    static final int FUNCTION_BETA = 112;
    static final int FUNCTION_SET = 113;
    static final int FUNCTIONS_COUNT = 114;
    static String[] function_names = new String[]{"N", "Plus", "Subtract", "Minus", "Times", "Divide", "Power", "Abs", "Sign", "Round", "IntegerPart", "FractionalPart", "Floor", "Ceiling", "Chop", "Max", "Min", "Re", "Im", "Conjugate", "Arg", "Mod", "Quotient", "Random", "SeedRandom", "Log", "Exp", "Sqrt", "Sin", "Cos", "Tan", "Csc", "Sec", "Cot", "ArcSin", "ArcCos", "ArcTan", "ArcCsc", "ArcSec", "ArcCot", "Sinh", "Cosh", "Tanh", "Csch", "Sech", "Coth", "ArcSinh", "ArcCosh", "ArcTanh", "ArcCsch", "ArcSech", "ArcCoth", "Factorial", "Factorial2", "Binomial", "Multinomial", "Pochhammer", "Gamma", "LogGamma", "PowerMod", "Erf", "Erfc", "Erfi", "Rationalize", "Equal", "Unequal", "Less", "Greater", "LessEqual", "GreaterEqual", "NumberQ", "NumericQ", "IntegerQ", "EvenQ", "OddQ", "Positive", "Negative", "NonPositive", "NonNegative", "TrueQ", "ValueQ", "Not", "And", "Or", "Xor", "Implies", "If", "Which", "Switch", "Identity", "Evaluate", "Hold", "HoldComplete", "HoldForm", "ReleaseHold", "NumberForm", "ScientificForm", "EngineeringForm", "AccountingForm", "PaddedForm", "StandardForm", "TraditionalForm", "InputForm", "OutputForm", "DisplayForm", "FullForm", "SessionTime", "TimeUsed", "AbsoluteTime", "DiscreteDelta", "KroneckerDelta", "UnitStep", "Beta", "Set"};
    boolean scanning_EdgeForm;
    boolean scanning_FaceForm;
    boolean scanning_FaceForm_back;
    boolean scanning_SurfaceColor;
    boolean scanning_SurfaceColor_specular;
    boolean scanning_AxesStyles;
    int scanned_AnimationDirection = 1;
    double scanned_Animate_min = 0.0;
    double scanned_Animate_max = 0.0;
    double scanned_Animate_step = 1.0;
    int scanned_Animate_variable = -1;
    Vector scanned_frames;
    boolean scanning_animation_option = false;
    Graphics3D graphics;
    boolean is_scanned_AmbientLight;
    boolean is_scanned_Axes;
    boolean is_scanned_AxesLabel;
    boolean is_scanned_AxesStyle;
    boolean is_scanned_AxesEdge;
    boolean is_scanned_Ticks;
    boolean is_scanned_PlotLabel;
    boolean is_scanned_Background;
    boolean is_scanned_DefaultColor;
    boolean is_scanned_BoxStyle;
    boolean is_scanned_Boxed;
    boolean is_scanned_Lighting;
    boolean is_scanned_BoxRatios;
    boolean is_scanned_PlotRange;
    boolean is_scanned_LightSources;
    boolean is_scanned_ViewPoint;
    boolean is_scanned_ViewVertical;
    boolean is_scanned_TextStyle;
    boolean is_scanned_AnimationDisplayTime;
    boolean scanned_nothing;
    boolean scanned_unidentified;
    int recursion_depth = 0;
    int if_recursion_depth = 0;
    Primitive3D[] scanned_AxesStyles = new Primitive3D[]{null, null, null};
    static int max_count_scanned_numbers = 4;
    double[] scanned_numbers = new double[max_count_scanned_numbers];
    int count_scanned_numbers;
    int count_scanned_points;
    double[][] scanned_points;
    double[][] scanned_scaled_offsets;
    int[][] scanned_expressions;
    Vector points_scanned;
    Vector scaled_offsets_scanned;
    Vector expressions_scanned;
    Color scanned_color;
    String scanned_font_url;
    String scanned_font_family;
    int scanned_font_weight;
    int scanned_font_slant;
    int scanned_font_size;
    Color scanned_font_color;
    Color scanned_font_background;
    Vector scanned_font_substitutions;
    double scanned_script_size_multipliers;
    int scanned_script_min_size;
    double scanned_script_baseline_shift1;
    double scanned_script_baseline_shift2;
    double scanned_script_baseline_shift3;
    double scanned_script_baseline_shift4;
    int scanned_expression;
    boolean is_scanned_expression_numeric;
    static int[] arguments_counts = new int[1000];

    public Parser(String new_text, Evaluator new_evaluator) {
        this.evaluator = new_evaluator;
        this.set_text(new_text);
    }

    public void set_text(String new_text) {
        this.text = new_text;
        this.text_index = -1;
        this.current_char = '\u0000';
        this.last_text_index = -1;
        this.last_char = '\u0000';
        this.is_scanning_expression = false;
        this.is_scanning_after_operand = false;
    }

    Color copied_color(Color color) {
        if (null == color) {
            return null;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    boolean isDigitOrLetterLike(char ch) {
        char c = ch;
        return c <= '\u0172' && isletter0to370[c] || '\u025b' == c || '\u0306' <= c && c <= '\u03f1' && isletter774to1009[c - 774] || '\u2013' <= c && c <= '\u2138' && isletter8211to8504[c - 8211] || '\u2013' <= c && c <= '\u2138' && isletter8211to8504[c - 8211] || '\u2202' <= c && c <= '\u2222' && isletter8706to8738[c - 8706] || '\u22ee' <= c && c <= '\u22f1' || '\u25a2' <= c && c <= '\u266f' && isletter9634to9839[c - 9634] || '\uf404' == c || '\uf527' <= c && c <= '\uf529' || '\uf601' <= c && c <= '\uf7bd' && isletter62977to63421[c - 62977];
    }

    char next_char() {
        boolean processed = false;
        this.last_char = this.current_char;
        this.last_text_index = this.text_index++;
        if (this.text_index < 0 || this.text_index >= this.text.length()) {
            this.current_char = (char)12;
            return this.current_char;
        }
        while (!processed) {
            this.current_char = this.text.charAt(this.text_index);
            if ('\\' == this.current_char && this.text_index + 1 < this.text.length()) {
                ++this.text_index;
                this.current_char = this.text.charAt(this.text_index);
                if ('[' == this.current_char) {
                    int special_char_index = ++this.text_index;
                    while (this.text_index < this.text.length() && (this.isDigitOrLetterLike(this.text.charAt(this.text_index)) || 0 <= breaking_chars.indexOf(this.text.charAt(this.text_index)))) {
                        ++this.text_index;
                    }
                    if (this.text_index >= this.text.length() || ']' != this.text.charAt(this.text_index)) {
                        this.text_index = this.last_text_index + 1;
                        this.current_char = (char)92;
                        processed = true;
                        continue;
                    }
                    String char_name = this.text.substring(special_char_index, this.text_index);
                    int length = -1;
                    int offset = 0;
                    block2: while (length != char_name.length()) {
                        int part_length;
                        length = char_name.length();
                        int index = 0;
                        while ((part_length = standard_parts[index].length()) > 0) {
                            if (char_name.regionMatches(offset, standard_parts[index], 0, part_length)) {
                                char_name = char_name.substring(0, offset) + standard_short_parts[index] + char_name.substring(offset + part_length);
                                ++offset;
                                continue block2;
                            }
                            ++index;
                        }
                    }
                    int uni_code = -1;
                    if (char_name.equals("n")) {
                        uni_code = 172;
                    } else if (char_name.length() >= 2) {
                        offset = 0;
                        String pattern = char_name.substring(0, 2);
                        while (offset >= 0) {
                            if ((offset = coded_char_names.indexOf(pattern, offset + 1)) < 0 || !Character.isDigit(coded_char_names.charAt(offset - 1))) continue;
                            int digit_index = offset + 2;
                            while (!Character.isDigit(coded_char_names.charAt(digit_index))) {
                                ++digit_index;
                            }
                            int end_digit_index = digit_index + 1;
                            while (Character.isDigit(coded_char_names.charAt(end_digit_index))) {
                                ++end_digit_index;
                            }
                            if (!char_name.regionMatches(0, coded_char_names, offset, digit_index - offset)) continue;
                            offset = -1;
                            uni_code = Integer.parseInt(coded_char_names.substring(digit_index, end_digit_index));
                        }
                    }
                    this.current_char = uni_code >= 0 ? (char)uni_code : (char)191;
                    processed = true;
                    continue;
                }
                if (0 <= white_characters.indexOf(this.current_char)) {
                    ++this.text_index;
                    while (this.text_index < this.text.length() && 0 <= white_characters.indexOf(this.text.charAt(this.text_index))) {
                        ++this.text_index;
                    }
                    if (this.text_index >= this.text.length()) {
                        this.text_index = this.text.length() - 1;
                        this.current_char = (char)32;
                        processed = true;
                        continue;
                    }
                    processed = false;
                    continue;
                }
                this.current_char = (char)92;
                --this.text_index;
                processed = true;
                continue;
            }
            if (0 <= single_quote_chars.indexOf(this.current_char) && this.text_index + 1 < this.text.length() && 0 <= single_quote_chars.indexOf(this.text.charAt(this.text_index + 1))) {
                this.current_char = (char)34;
                ++this.text_index;
                processed = true;
                continue;
            }
            if ('(' == this.current_char && this.text_index + 1 < this.text.length() && '*' == this.text.charAt(this.text_index + 1)) {
                this.text_index = this.text.indexOf(comment_end, this.text_index + 1);
                this.text_index = -1 == this.text_index ? this.text.length() - 1 : ++this.text_index;
                this.current_char = (char)32;
                processed = true;
                continue;
            }
            processed = true;
        }
        return this.current_char;
    }

    void unget_char() {
        this.current_char = this.last_char;
        this.text_index = this.last_text_index;
    }

    char first_non_white_char() {
        while (this.text_index < this.text.length() && 0 <= white_characters.indexOf(this.current_char)) {
            this.next_char();
        }
        return this.current_char;
    }

    void scan_real() {
        int sign = 1;
        double integer_part = 0.0;
        double fraction_part = 0.0;
        int count_fraction_digits = 0;
        this.is_scanned_real = false;
        if ('-' == this.current_char) {
            sign = -1;
            this.next_char();
        } else if ('+' == this.current_char) {
            this.next_char();
        }
        int index = digit_characters.indexOf(this.current_char);
        if (0 <= index) {
            this.is_scanned_real = true;
        }
        while (0 <= index) {
            integer_part = 10.0 * integer_part + (double)index;
            index = digit_characters.indexOf(this.next_char());
        }
        if ('.' == this.current_char) {
            index = digit_characters.indexOf(this.next_char());
            if (0 <= index) {
                this.is_scanned_real = true;
            }
            while (0 <= index) {
                fraction_part = 10.0 * fraction_part + (double)index;
                ++count_fraction_digits;
                index = digit_characters.indexOf(this.next_char());
            }
        }
        if (this.is_scanned_real) {
            this.scanned_real = 0 == count_fraction_digits ? (double)sign * integer_part : (double)sign * (integer_part + Math.pow(0.1, count_fraction_digits) * fraction_part);
        }
    }

    void scan_token() {
        if (this.text_index < 0) {
            this.text_index = -1;
            this.next_char();
        }
        this.first_non_white_char();
        while (this.text_index < this.text.length()) {
            if (this.is_scanning_expression && '-' == this.current_char) {
                if ('>' == this.next_char()) {
                    this.scanned_token_type = 20;
                    this.is_scanning_after_operand = false;
                    this.next_char();
                    return;
                }
                if (this.is_scanning_after_operand) {
                    this.scanned_token_type = 8;
                    this.is_scanning_after_operand = false;
                } else {
                    this.scanned_token_type = 28;
                }
                return;
            }
            if (this.is_scanning_expression && '+' == this.current_char) {
                if (this.is_scanning_after_operand) {
                    this.scanned_token_type = 7;
                    this.is_scanning_after_operand = false;
                } else {
                    this.scanned_token_type = 27;
                }
                this.next_char();
                return;
            }
            if (0 <= number_start.indexOf(this.current_char)) {
                if (this.is_scanning_expression && this.is_scanning_after_operand) {
                    this.scanned_token_type = 9;
                    this.is_scanning_after_operand = false;
                    return;
                }
                double mantissa = 0.0;
                double exponent = 0.0;
                double sign = 1.0;
                boolean in_parenthesis = false;
                if ('-' == this.current_char) {
                    sign = -1.0;
                    this.next_char();
                    if ('>' == this.current_char) {
                        this.scanned_token_type = 20;
                        this.next_char();
                        return;
                    }
                    if ('(' == this.current_char) {
                        in_parenthesis = true;
                        this.next_char();
                    }
                }
                this.scan_real();
                if (this.is_scanned_real) {
                    mantissa = this.scanned_real;
                    if ('`' == this.current_char) {
                        this.next_char();
                        if ('`' == this.current_char) {
                            this.next_char();
                        }
                        this.scan_real();
                    }
                    boolean should_have_exponent = false;
                    boolean has_exponent = false;
                    if ('*' == this.current_char || 'e' == this.current_char || 'E' == this.current_char) {
                        should_have_exponent = true;
                        if ('e' == this.current_char || 'E' == this.current_char) {
                            has_exponent = true;
                        } else if ('1' == this.next_char()) {
                            if ('0' == this.next_char() && '^' == this.next_char()) {
                                has_exponent = true;
                            }
                        } else if ('^' == this.current_char) {
                            has_exponent = true;
                        } else {
                            this.unget_char();
                            should_have_exponent = false;
                        }
                        if (has_exponent) {
                            this.next_char();
                            this.scan_real();
                            if (this.is_scanned_real) {
                                exponent = this.scanned_real;
                            } else {
                                has_exponent = false;
                            }
                        }
                    }
                    if (!in_parenthesis || ')' == this.current_char) {
                        if (in_parenthesis) {
                            this.next_char();
                        }
                        if (has_exponent || !should_have_exponent) {
                            this.scanned_number = sign * mantissa * Math.pow(10.0, exponent);
                            this.scanned_token_type = 22;
                            if (this.is_scanning_expression) {
                                this.is_scanning_after_operand = true;
                            }
                            return;
                        }
                    }
                }
            } else {
                if (this.isDigitOrLetterLike(this.current_char)) {
                    if (this.is_scanning_expression && this.is_scanning_after_operand) {
                        this.scanned_token_type = 9;
                        this.is_scanning_after_operand = false;
                        return;
                    }
                    this.scanned_identifier_chars[0] = this.current_char;
                    int index = 1;
                    while (this.isDigitOrLetterLike(this.next_char())) {
                        if (index >= max_length_identifier) continue;
                        this.scanned_identifier_chars[index] = this.current_char;
                        ++index;
                    }
                    if (index == 1) {
                        switch (this.scanned_identifier_chars[0]) {
                            case '\u03c0': {
                                this.scanned_identifier = "Pi";
                                break;
                            }
                            case '\u221e': {
                                this.scanned_identifier = "Infinity";
                                break;
                            }
                            case '\uf74d': {
                                this.scanned_identifier = "E";
                                break;
                            }
                            case '\uf74e': 
                            case '\uf74f': {
                                this.scanned_identifier = "I";
                                break;
                            }
                            case '\u00b0': {
                                this.scanned_identifier = "Degree";
                                break;
                            }
                            default: {
                                this.scanned_identifier = new String(this.scanned_identifier_chars, 0, 1);
                                break;
                            }
                        }
                    } else {
                        this.scanned_identifier = new String(this.scanned_identifier_chars, 0, index);
                    }
                    if (this.is_scanning_expression) {
                        this.is_scanning_after_operand = true;
                    }
                    this.scanned_left_bracket = this.first_non_white_char() == '[';
                    this.scanned_token_type = 21;
                    return;
                }
                if (0 <= structure_characters.indexOf(this.current_char)) {
                    this.scanned_token_type = structure_characters.indexOf(this.current_char);
                    if (this.is_scanning_expression) {
                        if (1 == this.scanned_token_type && this.is_scanning_after_operand) {
                            this.scanned_token_type = 9;
                            this.is_scanning_after_operand = false;
                            return;
                        }
                        this.is_scanning_after_operand = 2 == this.scanned_token_type || 4 == this.scanned_token_type || 6 == this.scanned_token_type;
                    }
                    this.next_char();
                    return;
                }
                if (':' == this.current_char) {
                    if ('>' == this.next_char()) {
                        this.scanned_token_type = 20;
                        this.next_char();
                        if (this.is_scanning_expression) {
                            this.is_scanning_after_operand = false;
                        }
                        return;
                    }
                } else {
                    if ('\uf522' == this.current_char || '\uf51f' == this.current_char) {
                        this.scanned_token_type = 20;
                        this.next_char();
                        if (this.is_scanning_expression) {
                            this.is_scanning_after_operand = false;
                        }
                        return;
                    }
                    if ('\"' == this.current_char) {
                        StringBuffer buffer = new StringBuffer(60);
                        this.next_char();
                        while (this.text_index < this.text.length() && '\"' != this.current_char) {
                            if ('\\' == this.current_char) {
                                this.next_char();
                                if ('n' == this.current_char) {
                                    buffer.append('\n');
                                } else if ('b' == this.current_char) {
                                    buffer.append('\b');
                                } else if ('t' == this.current_char) {
                                    buffer.append('\t');
                                } else if ('r' == this.current_char) {
                                    buffer.append('\r');
                                } else if ('f' == this.current_char) {
                                    buffer.append('\f');
                                } else if (0 <= single_quote_chars.indexOf(this.current_char) || '\"' == this.current_char || '\\' == this.current_char) {
                                    buffer.append(this.current_char);
                                    this.current_char = (char)92;
                                } else if (0 <= octal_digits.indexOf(this.current_char) || '.' == this.current_char || ':' == this.current_char) {
                                    int index;
                                    int digit_index;
                                    int count_digits = 3;
                                    int uni_code = 0;
                                    if ('.' == this.current_char) {
                                        count_digits = 2;
                                        this.next_char();
                                    }
                                    if (':' == this.current_char) {
                                        count_digits = 4;
                                        this.next_char();
                                    }
                                    for (digit_index = 0; digit_index < count_digits && 0 <= (index = hexadecimal_digits.indexOf(this.current_char)); ++digit_index) {
                                        if (16 <= index) {
                                            index -= 6;
                                        }
                                        uni_code = 3 == count_digits ? uni_code * 8 + index : uni_code * 16 + index;
                                        if (digit_index + 1 >= count_digits) continue;
                                        this.next_char();
                                    }
                                    buffer.append((char)uni_code);
                                    if (digit_index < count_digits) {
                                        buffer.append(this.current_char);
                                    }
                                } else {
                                    buffer.append('\\');
                                    buffer.append(this.current_char);
                                }
                            } else if ('\n' != this.current_char && '\r' != this.current_char && '\t' != this.current_char && '\f' != this.current_char) {
                                buffer.append(this.current_char);
                            }
                            this.next_char();
                        }
                        if (this.text_index < this.text.length()) {
                            this.scanned_token_type = 23;
                            this.scanned_string = new String(buffer);
                            if (this.is_scanning_expression) {
                                this.is_scanning_after_operand = true;
                            }
                            this.next_char();
                            return;
                        }
                    } else if (this.is_scanning_expression) {
                        if ('*' == this.current_char || '\u00d7' == this.current_char) {
                            this.scanned_token_type = 9;
                            this.is_scanning_after_operand = false;
                            this.next_char();
                            return;
                        }
                        if ('/' == this.current_char || '\u00f7' == this.current_char) {
                            this.scanned_token_type = 10;
                            this.is_scanning_after_operand = false;
                            this.next_char();
                            return;
                        }
                        if ('^' == this.current_char) {
                            this.scanned_token_type = 11;
                            this.is_scanning_after_operand = false;
                            this.next_char();
                            return;
                        }
                        if ('\u00ac' == this.current_char) {
                            this.scanned_token_type = 34;
                            this.is_scanning_after_operand = false;
                            this.next_char();
                            return;
                        }
                        if ('\u2260' == this.current_char) {
                            this.scanned_token_type = 15;
                            this.is_scanning_after_operand = false;
                            this.next_char();
                            return;
                        }
                        if ('!' == this.current_char) {
                            if (!this.is_scanning_after_operand) {
                                this.scanned_token_type = 34;
                                this.is_scanning_after_operand = false;
                                this.next_char();
                                return;
                            }
                            this.next_char();
                            if ('=' == this.current_char) {
                                this.scanned_token_type = 15;
                                this.is_scanning_after_operand = false;
                                this.next_char();
                                return;
                            }
                            if ('!' == this.current_char) {
                                this.scanned_token_type = 13;
                                this.is_scanning_after_operand = true;
                                this.next_char();
                                return;
                            }
                            this.scanned_token_type = 12;
                            this.is_scanning_after_operand = true;
                            return;
                        }
                        if ('\uf431' == this.current_char) {
                            this.scanned_token_type = 14;
                            this.is_scanning_after_operand = false;
                            this.next_char();
                            return;
                        }
                        if ('=' == this.current_char) {
                            if ('=' == this.next_char()) {
                                this.scanned_token_type = 14;
                                this.is_scanning_after_operand = false;
                                this.next_char();
                                return;
                            }
                            this.scanned_token_type = 36;
                            this.is_scanning_after_operand = false;
                            return;
                        }
                        if ('\u2264' == this.current_char) {
                            this.scanned_token_type = 18;
                            this.is_scanning_after_operand = false;
                            this.next_char();
                            return;
                        }
                        if ('<' == this.current_char) {
                            if ('=' == this.next_char()) {
                                this.scanned_token_type = 18;
                                this.is_scanning_after_operand = false;
                                this.next_char();
                                return;
                            }
                            this.scanned_token_type = 16;
                            this.is_scanning_after_operand = false;
                            return;
                        }
                        if ('\u2265' == this.current_char) {
                            this.scanned_token_type = 19;
                            this.is_scanning_after_operand = false;
                            this.next_char();
                            return;
                        }
                        if ('>' == this.current_char) {
                            if ('=' == this.next_char()) {
                                this.scanned_token_type = 19;
                                this.is_scanning_after_operand = false;
                                this.next_char();
                                return;
                            }
                            this.scanned_token_type = 17;
                            this.is_scanning_after_operand = false;
                            return;
                        }
                        if ('\u2227' == this.current_char) {
                            this.scanned_token_type = 32;
                            this.next_char();
                            this.is_scanning_after_operand = false;
                            return;
                        }
                        if ('&' == this.current_char) {
                            if ('&' == this.next_char()) {
                                this.scanned_token_type = 32;
                                this.next_char();
                                this.is_scanning_after_operand = false;
                                return;
                            }
                        } else {
                            if ('\u2228' == this.current_char) {
                                this.scanned_token_type = 33;
                                this.next_char();
                                this.is_scanning_after_operand = false;
                                return;
                            }
                            if ('|' == this.current_char) {
                                if ('|' == this.next_char()) {
                                    this.scanned_token_type = 33;
                                    this.next_char();
                                    this.is_scanning_after_operand = false;
                                    return;
                                }
                            } else if (';' == this.current_char) {
                                this.scanned_token_type = 35;
                                this.next_char();
                                this.is_scanning_after_operand = false;
                                return;
                            }
                        }
                    }
                }
            }
            this.scan_salt();
        }
        this.scanned_token_type = this.is_scanning_expression ? 24 : 25;
    }

    void scan_salt() {
        int bracket_level = 0;
        while (this.text_index < this.text.length()) {
            if ('\"' == this.current_char) {
                this.next_char();
                while (this.text_index < this.text.length() && '\"' != this.current_char) {
                    if ('\\' == this.current_char) {
                        this.next_char();
                    }
                    this.next_char();
                }
            } else if (0 <= structure_characters.indexOf(this.current_char)) {
                if ('(' == this.current_char || '{' == this.current_char || '[' == this.current_char) {
                    ++bracket_level;
                } else if (')' == this.current_char || '}' == this.current_char || ']' == this.current_char ? --bracket_level < 0 : ',' == this.current_char && bracket_level == 0) break;
            }
            this.next_char();
        }
    }

    void scan_right_bracket() {
        this.scan_salt();
        while (this.text_index < this.text.length() && ',' == this.current_char) {
            this.next_char();
            this.scan_salt();
        }
        this.scan_token();
        if (4 != this.scanned_token_type && 2 != this.scanned_token_type && 6 != this.scanned_token_type) {
            this.scanned_token_type = 25;
        }
    }

    public boolean scan_animation() {
        this.text_index = -1;
        this.scanned_AnimationDirection = 1;
        this.scanned_Animate_min = 0.0;
        this.scanned_Animate_max = 0.0;
        this.scanned_Animate_step = 1.0;
        this.scanned_Animate_variable = -1;
        this.scanned_frames = new Vector();
        this.scanning_animation_option = false;
        this.scan_token();
        if (21 != this.scanned_token_type) {
            return false;
        }
        if (this.scanned_identifier.equals(name_Graphics3D)) {
            if (!this.scan_Graphics3D()) {
                return false;
            }
            this.scanned_frames.addElement(this.graphics);
        } else if (this.scanned_identifier.equals(name_ShowAnimation)) {
            this.scan_token();
            if (3 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (21 == this.scanned_token_type && this.scanned_identifier.equals(name_Graphics3D)) {
                if (!this.scan_Graphics3D()) {
                    return false;
                }
                this.scanned_frames.addElement(this.graphics);
            } else if (5 == this.scanned_token_type) {
                this.scanned_token_type = 0;
                while (0 == this.scanned_token_type) {
                    this.scan_token();
                    if (!this.scan_Graphics3D()) {
                        return false;
                    }
                    this.scanned_frames.addElement(this.graphics);
                    this.scan_token();
                }
                if (6 != this.scanned_token_type) {
                    return false;
                }
            } else {
                return false;
            }
            this.scan_token();
            this.scanning_animation_option = true;
            this.init_scan_Graphics3D();
            while (0 == this.scanned_token_type) {
                if (!this.scan_option()) {
                    return false;
                }
                this.scan_token();
            }
            if (4 != this.scanned_token_type) {
                return false;
            }
            this.distribute_options(this.scanned_frames);
        } else if (this.scanned_identifier.equals(name_Animate)) {
            this.scan_token();
            if (3 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (21 != this.scanned_token_type || !this.scanned_identifier.equals(name_Graphics3D)) {
                return false;
            }
            if (!this.scan_Graphics3D()) {
                return false;
            }
            this.scanned_frames.addElement(this.graphics);
            this.scan_token();
            if (0 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (5 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (21 != this.scanned_token_type) {
                return false;
            }
            this.scanned_Animate_variable = this.evaluator.getVariableIndex(this.scanned_identifier);
            if (0 > this.scanned_Animate_variable) {
                return false;
            }
            if (!this.evaluator.isVariableIndependent(this.scanned_Animate_variable)) {
                return false;
            }
            this.scan_token();
            if (0 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (22 != this.scanned_token_type) {
                return false;
            }
            this.scanned_Animate_min = this.scanned_number;
            this.scan_token();
            if (0 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (22 != this.scanned_token_type) {
                return false;
            }
            this.scanned_Animate_max = this.scanned_number;
            this.scan_token();
            if (0 == this.scanned_token_type) {
                this.scan_token();
                if (22 != this.scanned_token_type) {
                    return false;
                }
                this.scanned_Animate_step = this.scanned_number;
                this.scan_token();
            } else {
                this.scanned_Animate_step = 1.0;
            }
            if (6 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            this.scanning_animation_option = true;
            this.init_scan_Graphics3D();
            while (0 == this.scanned_token_type) {
                if (!this.scan_option()) {
                    return false;
                }
                this.scan_token();
            }
            if (4 != this.scanned_token_type) {
                return false;
            }
            this.distribute_options(this.scanned_frames);
        } else {
            return false;
        }
        return true;
    }

    public void init_scan_Graphics3D() {
        this.graphics = new Graphics3D();
        this.scanning_EdgeForm = false;
        this.scanning_FaceForm = false;
        this.scanning_SurfaceColor = false;
        this.is_scanned_AmbientLight = false;
        this.is_scanned_Axes = false;
        this.is_scanned_AxesLabel = false;
        this.is_scanned_AxesStyle = false;
        this.is_scanned_AxesEdge = false;
        this.is_scanned_Ticks = false;
        this.is_scanned_PlotLabel = false;
        this.is_scanned_Background = false;
        this.is_scanned_DefaultColor = false;
        this.is_scanned_BoxStyle = false;
        this.is_scanned_Boxed = false;
        this.is_scanned_Lighting = false;
        this.is_scanned_BoxRatios = false;
        this.is_scanned_PlotRange = false;
        this.is_scanned_LightSources = false;
        this.is_scanned_ViewPoint = false;
        this.is_scanned_ViewVertical = false;
        this.is_scanned_TextStyle = false;
        this.is_scanned_AnimationDisplayTime = false;
    }

    public void distribute_options(Vector scanned_frames) {
        for (int frame_index = 0; frame_index < scanned_frames.size(); ++frame_index) {
            Graphics3D frame = (Graphics3D)scanned_frames.elementAt(frame_index);
            if (this.is_scanned_AmbientLight) {
                frame.option_AmbientLight = this.graphics.option_AmbientLight;
            }
            if (this.is_scanned_Axes) {
                frame.option_Axes = this.graphics.option_Axes;
            }
            if (this.is_scanned_AxesLabel && null != this.graphics.option_AxesLabel) {
                if (null == frame.option_AxesLabel) {
                    frame.option_AxesLabel = new Primitive3D[3];
                }
                for (int index = 0; index < 3; ++index) {
                    frame.option_AxesLabel[index] = null != this.graphics.option_AxesLabel[index] ? new Primitive3D(this.graphics.option_AxesLabel[index]) : null;
                }
            }
            if (this.is_scanned_AxesStyle) {
                frame.option_AxesStyle = this.graphics.option_AxesStyle;
            }
            if (this.is_scanned_AxesEdge) {
                frame.option_AxesEdge = this.graphics.option_AxesEdge;
            }
            if (this.is_scanned_Ticks) {
                frame.option_Ticks = this.graphics.option_Ticks;
            }
            if (this.is_scanned_PlotLabel) {
                frame.option_PlotLabel = new Primitive3D(this.graphics.option_PlotLabel);
            }
            if (this.is_scanned_Background) {
                frame.option_Background = this.graphics.option_Background;
            }
            if (this.is_scanned_DefaultColor) {
                frame.option_DefaultColor = this.graphics.option_DefaultColor;
            }
            if (this.is_scanned_BoxStyle) {
                frame.option_BoxStyle = this.graphics.option_BoxStyle;
            }
            if (this.is_scanned_Boxed) {
                frame.option_Boxed = this.graphics.option_Boxed;
            }
            if (this.is_scanned_Lighting) {
                frame.option_Lighting = this.graphics.option_Lighting;
            }
            if (this.is_scanned_BoxRatios) {
                frame.option_BoxRatios = this.graphics.option_BoxRatios;
            }
            if (this.is_scanned_PlotRange) {
                frame.option_PlotRange = this.graphics.option_PlotRange;
            }
            if (this.is_scanned_LightSources) {
                frame.option_LightSources_vectors = this.graphics.option_LightSources_vectors;
                frame.option_LightSources_colors = this.graphics.option_LightSources_colors;
            }
            if (this.is_scanned_ViewPoint) {
                frame.option_ViewPoint = this.graphics.option_ViewPoint;
            }
            if (this.is_scanned_ViewVertical) {
                frame.option_ViewVertical = this.graphics.option_ViewVertical;
            }
            if (this.is_scanned_TextStyle) {
                frame.option_TextStyle_font_url = this.graphics.option_TextStyle_font_url;
                frame.option_TextStyle_font_family = this.graphics.option_TextStyle_font_family;
                frame.option_TextStyle_font_weight = this.graphics.option_TextStyle_font_weight;
                frame.option_TextStyle_font_slant = this.graphics.option_TextStyle_font_slant;
                frame.option_TextStyle_font_size = this.graphics.option_TextStyle_font_size;
                frame.option_TextStyle_font_color = this.graphics.option_TextStyle_font_color;
                frame.option_TextStyle_font_background = this.graphics.option_TextStyle_font_background;
                if (null != this.graphics.option_TextStyle_font_substitutions) {
                    frame.option_TextStyle_font_substitutions = this.graphics.option_TextStyle_font_substitutions;
                }
                frame.option_TextStyle_script_size_multipliers = this.graphics.option_TextStyle_script_size_multipliers;
                frame.option_TextStyle_script_min_size = this.graphics.option_TextStyle_script_min_size;
                frame.option_TextStyle_script_baseline_shift1 = this.graphics.option_TextStyle_script_baseline_shift1;
                frame.option_TextStyle_script_baseline_shift2 = this.graphics.option_TextStyle_script_baseline_shift2;
                frame.option_TextStyle_script_baseline_shift3 = this.graphics.option_TextStyle_script_baseline_shift3;
                frame.option_TextStyle_script_baseline_shift4 = this.graphics.option_TextStyle_script_baseline_shift4;
            }
            if (!this.is_scanned_AnimationDisplayTime) continue;
            frame.option_AnimationDisplayTime = this.graphics.option_AnimationDisplayTime;
            frame.option_AnimationDisplayTimeString = this.graphics.option_AnimationDisplayTimeString;
        }
    }

    public boolean scan_Graphics3D() {
        this.init_scan_Graphics3D();
        Primitive3D default_primitive = new Primitive3D();
        if (21 != this.scanned_token_type || !this.scanned_identifier.equals(name_Graphics3D)) {
            return false;
        }
        this.scan_token();
        if (3 != this.scanned_token_type) {
            return false;
        }
        if (!this.scan_primitive(default_primitive)) {
            return false;
        }
        this.scan_token();
        while (0 == this.scanned_token_type) {
            if (!this.scan_option()) {
                return false;
            }
            this.scan_token();
        }
        if (4 != this.scanned_token_type) {
            return false;
        }
        this.graphics.original_count_primitives = this.graphics.count_primitives;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    boolean scan_primitive(Primitive3D default_primitive) {
        this.scanned_nothing = false;
        this.scanned_unidentified = false;
        this.scan_token();
        if (5 == this.scanned_token_type) {
            if (!this.scanning_EdgeForm && !this.scanning_FaceForm || this.scanning_AxesStyles && 1 == this.recursion_depth) {
                default_primitive = new Primitive3D(default_primitive);
            }
            ++this.recursion_depth;
            while (this.scan_primitive(default_primitive)) {
                this.scan_token();
                if (0 == this.scanned_token_type) continue;
            }
            --this.recursion_depth;
            if (6 != this.scanned_token_type) {
                return false;
            }
            if (this.scanning_AxesStyles && 1 == this.recursion_depth) {
                this.scanned_AxesStyles[0] = this.scanned_AxesStyles[1];
                this.scanned_AxesStyles[1] = this.scanned_AxesStyles[2];
                this.scanned_AxesStyles[2] = default_primitive;
            }
            return true;
        }
        if (21 != this.scanned_token_type) {
            this.scanned_nothing = true;
            return false;
        }
        if (!this.scanning_EdgeForm && !this.scanning_FaceForm && !this.scanning_SurfaceColor && null != this.evaluator && this.scanned_identifier.equals(name_If)) {
            int if_clause_min_index = -1;
            int if_clause_max_index = -1;
            int else_clause_min_index = -1;
            int else_clause_max_index = -1;
            int default_clause_min_index = -1;
            int default_clause_max_index = -1;
            this.scan_token();
            if (3 != this.scanned_token_type) {
                return false;
            }
            this.is_scanning_expression = true;
            this.is_scanning_after_operand = false;
            this.scan_token();
            if (!this.scan_expression(true)) {
                return false;
            }
            this.is_scanning_expression = false;
            if (0 != this.scanned_token_type) {
                return false;
            }
            int if_condition_expression = this.scanned_expression;
            double if_condition_number = this.scanned_number;
            boolean is_if_condition_numeric = this.is_scanned_expression_numeric;
            ++this.if_recursion_depth;
            if_clause_min_index = this.graphics.count_primitives;
            ++this.recursion_depth;
            if (!this.scan_primitive(new Primitive3D(default_primitive))) {
                --this.recursion_depth;
                --this.if_recursion_depth;
                return false;
            }
            --this.recursion_depth;
            if_clause_max_index = this.graphics.count_primitives - 1;
            this.scan_token();
            if (0 == this.scanned_token_type) {
                else_clause_min_index = this.graphics.count_primitives;
                ++this.recursion_depth;
                if (!this.scan_primitive(new Primitive3D(default_primitive))) {
                    --this.recursion_depth;
                    --this.if_recursion_depth;
                    return false;
                }
                --this.recursion_depth;
                else_clause_max_index = this.graphics.count_primitives - 1;
                this.scan_token();
                if (0 == this.scanned_token_type) {
                    default_clause_min_index = this.graphics.count_primitives;
                    ++this.recursion_depth;
                    if (!this.scan_primitive(new Primitive3D(default_primitive))) {
                        --this.recursion_depth;
                        --this.if_recursion_depth;
                        return false;
                    }
                    --this.recursion_depth;
                    default_clause_max_index = this.graphics.count_primitives - 1;
                    this.scan_token();
                }
            }
            if (4 != this.scanned_token_type) {
                --this.if_recursion_depth;
                return false;
            }
            --this.if_recursion_depth;
            int inactive_flag = this.if_recursion_depth < 32 ? 1 << this.if_recursion_depth : 0;
            if (1.0 == if_condition_number) {
                this.graphics.clearInactiveFlags(if_clause_min_index, if_clause_max_index, inactive_flag);
                this.graphics.setInactiveFlags(else_clause_min_index, else_clause_max_index, inactive_flag);
                this.graphics.setInactiveFlags(default_clause_min_index, default_clause_max_index, inactive_flag);
            } else if (0.0 == if_condition_number) {
                this.graphics.setInactiveFlags(if_clause_min_index, if_clause_max_index, inactive_flag);
                this.graphics.clearInactiveFlags(else_clause_min_index, else_clause_max_index, inactive_flag);
                this.graphics.setInactiveFlags(default_clause_min_index, default_clause_max_index, inactive_flag);
            } else {
                this.graphics.setInactiveFlags(if_clause_min_index, if_clause_max_index, inactive_flag);
                this.graphics.setInactiveFlags(else_clause_min_index, else_clause_max_index, inactive_flag);
                this.graphics.clearInactiveFlags(default_clause_min_index, default_clause_max_index, inactive_flag);
            }
            if (!is_if_condition_numeric) {
                this.evaluator.setExpressionIfCondition(if_condition_expression, this.graphics, inactive_flag, if_clause_min_index, if_clause_max_index, else_clause_min_index, else_clause_max_index, default_clause_min_index, default_clause_max_index);
            }
            return true;
        }
        if (!this.scanning_EdgeForm && !this.scanning_FaceForm && !this.scanning_SurfaceColor && this.scanned_identifier.equals(name_EdgeForm)) {
            this.scan_token();
            if (3 != this.scanned_token_type) {
                return false;
            }
            this.scanning_EdgeForm = true;
            default_primitive.is_outlined = false;
            if (this.scan_primitive(default_primitive)) {
                this.scanning_EdgeForm = false;
                this.scan_token();
                return 4 == this.scanned_token_type;
            }
            if (this.scanned_nothing && 4 == this.scanned_token_type) {
                this.scanning_EdgeForm = false;
                return true;
            }
        } else {
            if (!this.scanning_EdgeForm && !this.scanning_FaceForm && !this.scanning_SurfaceColor && this.scanned_identifier.equals(name_FaceForm)) {
                this.scan_token();
                if (3 != this.scanned_token_type) {
                    return false;
                }
                this.scanning_FaceForm = true;
                this.scanning_FaceForm_back = false;
                if (!this.scan_primitive(default_primitive)) {
                    this.scanning_FaceForm = false;
                    return false;
                }
                this.scan_token();
                if (0 == this.scanned_token_type) {
                    this.scanning_FaceForm_back = true;
                    if (!this.scan_primitive(default_primitive)) {
                        this.scanning_FaceForm = false;
                        this.scanning_FaceForm_back = false;
                        return false;
                    }
                    this.scanning_FaceForm_back = false;
                    this.scan_token();
                }
                this.scanning_FaceForm = false;
                return 4 == this.scanned_token_type;
            }
            if (!this.scanning_EdgeForm && !this.scanning_SurfaceColor && this.scanned_identifier.equals(name_SurfaceColor)) {
                this.scan_token();
                if (3 != this.scanned_token_type) {
                    return false;
                }
                this.scanning_SurfaceColor = true;
                this.scanning_SurfaceColor_specular = false;
                if (!this.scan_primitive(default_primitive)) {
                    this.scanning_SurfaceColor = false;
                    return false;
                }
                this.scan_token();
                if (0 == this.scanned_token_type) {
                    this.scanning_SurfaceColor_specular = true;
                    if (!this.scan_primitive(default_primitive)) {
                        this.scanning_SurfaceColor = false;
                        this.scanning_SurfaceColor_specular = false;
                        return false;
                    }
                    this.scanning_SurfaceColor = false;
                    this.scanning_SurfaceColor_specular = false;
                    this.scan_token();
                    if (0 == this.scanned_token_type) {
                        this.scan_token();
                        if (22 != this.scanned_token_type) {
                            return false;
                        }
                        if (!this.scanning_FaceForm_back) {
                            default_primitive.front_specular_exponent = this.scanned_number;
                        }
                        default_primitive.back_specular_exponent = this.scanned_number;
                        this.scan_token();
                    }
                }
                this.scanning_SurfaceColor = false;
                return 4 == this.scanned_token_type;
            }
        }
        if (!this.scan_color()) {
            return false;
        }
        if (null != this.scanned_color) {
            if (this.scanning_SurfaceColor && !this.scanning_SurfaceColor_specular) {
                if (!this.scanning_FaceForm_back) {
                    default_primitive.front_diffuse_color = this.scanned_color;
                }
                default_primitive.back_diffuse_color = this.scanned_color;
            } else if (this.scanning_SurfaceColor && this.scanning_SurfaceColor_specular) {
                if (!this.scanning_FaceForm_back) {
                    default_primitive.front_specular_color = this.scanned_color;
                }
                default_primitive.back_specular_color = this.scanned_color;
            } else if (this.scanning_FaceForm) {
                if (!this.scanning_FaceForm_back) {
                    default_primitive.front_face_color = this.scanned_color;
                }
                default_primitive.back_face_color = this.scanned_color;
            } else if (this.scanning_EdgeForm) {
                default_primitive.edge_color = this.scanned_color;
                default_primitive.is_outlined = true;
            } else {
                default_primitive.standard_color = this.scanned_color;
                default_primitive.front_face_color = this.scanned_color;
                default_primitive.back_face_color = this.scanned_color;
            }
            return true;
        }
        if (!(this.scanning_SurfaceColor || this.scanning_EdgeForm || this.scanning_FaceForm)) {
            if (this.scanned_identifier.equals(name_PointSize)) {
                if (!this.scan_numbers(false, false) || 1 != this.count_scanned_numbers) {
                    return false;
                }
                default_primitive.original_point_size = this.scanned_numbers[0];
                default_primitive.is_absolute_point_size = false;
                return true;
            }
            if (this.scanned_identifier.equals(name_AbsolutePointSize)) {
                if (!this.scan_numbers(false, false) || 1 != this.count_scanned_numbers) {
                    return false;
                }
                default_primitive.original_point_size = this.scanned_numbers[0];
                default_primitive.is_absolute_point_size = true;
                return true;
            }
        }
        if (!this.scanning_SurfaceColor && !this.scanning_FaceForm) {
            if (this.scanned_identifier.equals(name_Thickness)) {
                if (!this.scan_numbers(false, false) || 1 != this.count_scanned_numbers) {
                    return false;
                }
                if (this.scanning_EdgeForm) {
                    default_primitive.is_outlined = true;
                    default_primitive.original_edge_thickness = this.scanned_numbers[0];
                    default_primitive.is_absolute_edge_thickness = false;
                } else {
                    default_primitive.original_thickness = this.scanned_numbers[0];
                    default_primitive.is_absolute_thickness = false;
                }
                return true;
            }
            if (this.scanned_identifier.equals(name_AbsoluteThickness)) {
                if (!this.scan_numbers(false, false) || 1 != this.count_scanned_numbers) {
                    return false;
                }
                if (this.scanning_EdgeForm) {
                    default_primitive.is_outlined = true;
                    default_primitive.original_edge_thickness = this.scanned_numbers[0];
                    default_primitive.is_absolute_edge_thickness = true;
                } else {
                    default_primitive.original_thickness = this.scanned_numbers[0];
                    default_primitive.is_absolute_thickness = true;
                }
                return true;
            }
        }
        if (!(this.scanning_EdgeForm || this.scanning_FaceForm || this.scanning_SurfaceColor)) {
            if (this.scanned_identifier.equals(name_Point)) {
                this.scan_token();
                if (3 != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_points() || 1 != this.count_scanned_points) {
                    return false;
                }
                this.scan_token();
                if (4 != this.scanned_token_type) {
                    return false;
                }
                Primitive3D primitive = new Primitive3D(default_primitive);
                primitive.count_points = 1;
                primitive.original_points = this.scanned_points;
                primitive.original_scaled_offsets = this.scanned_scaled_offsets;
                primitive.original_expressions = this.scanned_expressions;
                primitive.is_filled = false;
                primitive.is_outlined = false;
                this.graphics.addPrimitive(primitive);
                return true;
            }
            if (this.scanned_identifier.equals(name_Line)) {
                this.scan_token();
                if (3 != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_points()) {
                    return false;
                }
                this.scan_token();
                if (4 != this.scanned_token_type) {
                    return false;
                }
                Primitive3D primitive = new Primitive3D(default_primitive);
                primitive.count_points = this.count_scanned_points;
                primitive.original_points = this.scanned_points;
                primitive.original_scaled_offsets = this.scanned_scaled_offsets;
                primitive.original_expressions = this.scanned_expressions;
                primitive.is_filled = false;
                primitive.is_outlined = false;
                this.graphics.addPrimitive(primitive);
                return true;
            }
            if (this.scanned_identifier.equals(name_Polygon)) {
                boolean[] scanned_edge_flags = null;
                this.scan_token();
                if (3 != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_points()) {
                    return false;
                }
                this.scan_token();
                if (0 == this.scanned_token_type) {
                    this.scan_salt();
                    this.scan_token();
                    if (0 == this.scanned_token_type) {
                        this.scan_token();
                        if (5 != this.scanned_token_type) {
                            this.scan_salt();
                            this.scan_token();
                        } else {
                            scanned_edge_flags = new boolean[this.count_scanned_points];
                            int edge_index = 0;
                            while (6 != this.scanned_token_type) {
                                this.scan_token();
                                if (21 != this.scanned_token_type) {
                                    this.scan_salt();
                                    this.scan_token();
                                }
                                if (this.scanned_identifier.equals(name_True)) {
                                    if (edge_index < this.count_scanned_points) {
                                        scanned_edge_flags[edge_index] = true;
                                    }
                                    this.scan_token();
                                } else if (this.scanned_identifier.equals(name_False)) {
                                    if (edge_index < this.count_scanned_points) {
                                        scanned_edge_flags[edge_index] = false;
                                    }
                                    this.scan_token();
                                } else {
                                    this.scan_salt();
                                    this.scan_token();
                                }
                                if (0 != this.scanned_token_type && 6 != this.scanned_token_type) {
                                    return false;
                                }
                                ++edge_index;
                            }
                            if (edge_index != this.count_scanned_points) {
                                scanned_edge_flags = null;
                            }
                            this.scan_token();
                        }
                    }
                }
                if (4 != this.scanned_token_type) {
                    return false;
                }
                Primitive3D primitive = new Primitive3D(default_primitive);
                primitive.count_points = this.count_scanned_points;
                primitive.original_points = this.scanned_points;
                primitive.original_scaled_offsets = this.scanned_scaled_offsets;
                primitive.original_expressions = this.scanned_expressions;
                primitive.edge_flags = scanned_edge_flags;
                primitive.is_filled = true;
                this.graphics.addPrimitive(primitive);
                return true;
            }
            if (this.scanned_identifier.equals(name_Cuboid)) {
                void var4_19;
                double[] max_scaled_offset;
                double[] max_point;
                int[][] cuboid_codes = new int[][]{{0, 1, 3, 2}, {0, 4, 5, 1}, {0, 2, 6, 4}, {7, 6, 4, 5}, {7, 3, 2, 6}, {7, 5, 1, 3}};
                this.scan_token();
                if (3 != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_points() || 1 != this.count_scanned_points) {
                    return false;
                }
                double[] min_point = this.scanned_points[0];
                double[] min_scaled_offset = this.scanned_scaled_offsets[0];
                if (null != this.scanned_expressions && (this.scanned_expressions[0][0] >= 0 || this.scanned_expressions[0][1] >= 0 || this.scanned_expressions[0][2] >= 0)) {
                    return false;
                }
                this.scan_token();
                if (4 == this.scanned_token_type) {
                    if (null != min_point) {
                        max_point = new double[]{min_point[0] + 1.0, min_point[1] + 1.0, min_point[2] + 1.0};
                        max_scaled_offset = min_scaled_offset;
                    } else {
                        max_point = null;
                        max_scaled_offset = null;
                    }
                } else if (0 == this.scanned_token_type) {
                    if (!this.scan_points() || 1 != this.count_scanned_points) {
                        return false;
                    }
                    if (null != this.scanned_expressions && (this.scanned_expressions[0][0] >= 0 || this.scanned_expressions[0][1] >= 0 || this.scanned_expressions[0][2] >= 0)) {
                        return false;
                    }
                    this.scan_token();
                    if (4 != this.scanned_token_type) {
                        return false;
                    }
                    max_point = this.scanned_points[0];
                    max_scaled_offset = this.scanned_scaled_offsets[0];
                } else {
                    return false;
                }
                if (null != min_point && null != var4_19 || null == min_point && null == var4_19 && null != max_scaled_offset) {
                    for (int face_index = 0; face_index < 6; ++face_index) {
                        Primitive3D primitive = new Primitive3D(default_primitive);
                        primitive.count_points = 4;
                        primitive.original_points = new double[4][3];
                        primitive.original_scaled_offsets = new double[4][3];
                        primitive.is_filled = true;
                        for (int corner_index = 0; corner_index < 4; ++corner_index) {
                            for (int axes_index = 0; axes_index < 3; ++axes_index) {
                                if (0 != (cuboid_codes[face_index][corner_index] & 1 << axes_index)) {
                                    if (null != var4_19) {
                                        primitive.original_points[corner_index][axes_index] = var4_19[axes_index];
                                    } else {
                                        primitive.original_points[corner_index] = null;
                                    }
                                    primitive.original_scaled_offsets[corner_index][axes_index] = max_scaled_offset[axes_index];
                                    continue;
                                }
                                if (null != min_point) {
                                    primitive.original_points[corner_index][axes_index] = min_point[axes_index];
                                } else {
                                    primitive.original_points[corner_index] = null;
                                }
                                primitive.original_scaled_offsets[corner_index][axes_index] = min_scaled_offset[axes_index];
                            }
                        }
                        this.graphics.addPrimitive(primitive);
                    }
                }
                return true;
            }
            if (this.scanned_identifier.equals(name_Text)) {
                Primitive3D primitive = new Primitive3D(default_primitive);
                this.scan_token();
                if (3 != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (!this.scan_text(primitive, true)) {
                    return false;
                }
                this.scan_token();
                if (0 != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_points() || 1 != this.count_scanned_points) {
                    return false;
                }
                primitive.count_points = 1;
                primitive.original_points = this.scanned_points;
                primitive.original_scaled_offsets = this.scanned_scaled_offsets;
                primitive.original_expressions = this.scanned_expressions;
                this.scan_token();
                double x_offset = 0.0;
                double y_offset = 0.0;
                if (0 == this.scanned_token_type) {
                    if (!this.scan_numbers(false, true) || 2 != this.count_scanned_numbers) {
                        return false;
                    }
                    x_offset = this.scanned_numbers[0];
                    y_offset = this.scanned_numbers[1];
                    this.scan_right_bracket();
                }
                if (4 != this.scanned_token_type) {
                    return false;
                }
                primitive.original_point_size = x_offset;
                primitive.original_thickness = y_offset;
                this.graphics.addPrimitive(primitive);
                return true;
            }
        }
        this.scan_salt();
        if (',' == this.current_char || '}' == this.current_char || ']' == this.current_char) {
            this.scanned_unidentified = true;
            return true;
        }
        return false;
    }

    boolean scan_numbers(boolean chop, boolean brace) {
        int index;
        this.scan_token();
        if (!brace && 3 != this.scanned_token_type || brace && 5 != this.scanned_token_type) {
            return false;
        }
        for (index = 0; index < max_count_scanned_numbers; ++index) {
            this.scan_token();
            if (22 != this.scanned_token_type) break;
            this.scanned_numbers[index] = this.scanned_number;
            if (chop) {
                if (this.scanned_number > 0.9999) {
                    this.scanned_numbers[index] = 0.9999;
                } else if (this.scanned_number < 1.0E-4) {
                    this.scanned_numbers[index] = 1.0E-4;
                }
            }
            this.scan_token();
            if (0 == this.scanned_token_type) continue;
        }
        this.count_scanned_numbers = index;
        if ((!brace && 4 != this.scanned_token_type || brace && 6 != this.scanned_token_type) && index >= max_count_scanned_numbers) {
            this.scan_right_bracket();
        }
        return (brace || 4 == this.scanned_token_type) && (!brace || 6 == this.scanned_token_type);
    }

    boolean scan_points() {
        boolean is_list = false;
        boolean scanned_brace = false;
        int point_index = 0;
        this.scanned_points = null;
        this.scanned_scaled_offsets = null;
        this.scanned_expressions = null;
        this.points_scanned = new Vector(2);
        this.scaled_offsets_scanned = new Vector(2);
        if (null != this.evaluator) {
            this.is_scanning_expression = true;
            this.is_scanning_after_operand = false;
            this.expressions_scanned = new Vector(2);
        }
        while (0 == point_index || is_list && 0 == this.scanned_token_type) {
            int index;
            double[] point = new double[]{0.0, 0.0, 0.0};
            double[] scaled_offset = new double[]{0.0, 0.0, 0.0};
            int[] expressions = new int[]{-1, -1, -1};
            this.scan_token();
            if (5 == this.scanned_token_type) {
                this.scan_token();
                if (0 == point_index) {
                    if (5 == this.scanned_token_type) {
                        is_list = true;
                        this.scan_token();
                    } else if (21 == this.scanned_token_type && this.scanned_identifier.equals(name_Scaled)) {
                        is_list = true;
                    }
                }
            }
            if (21 == this.scanned_token_type && this.scanned_identifier.equals(name_Scaled)) {
                this.scan_token();
                if (3 != this.scanned_token_type) {
                    this.points_scanned = null;
                    this.scaled_offsets_scanned = null;
                    this.is_scanning_expression = false;
                    return false;
                }
                if (!this.scan_numbers(false, true) || 3 != this.count_scanned_numbers) {
                    this.points_scanned = null;
                    this.scaled_offsets_scanned = null;
                    this.is_scanning_expression = false;
                    return false;
                }
                scaled_offset[0] = this.scanned_numbers[0];
                scaled_offset[1] = this.scanned_numbers[1];
                scaled_offset[2] = this.scanned_numbers[2];
                this.scan_token();
                if (0 == this.scanned_token_type) {
                    if (!this.scan_numbers(false, true) || 3 != this.count_scanned_numbers) {
                        this.points_scanned = null;
                        this.scaled_offsets_scanned = null;
                        this.is_scanning_expression = false;
                        return false;
                    }
                    point[0] = this.scanned_numbers[0];
                    point[1] = this.scanned_numbers[1];
                    point[2] = this.scanned_numbers[2];
                    this.scan_token();
                    if (4 != this.scanned_token_type) {
                        this.points_scanned = null;
                        this.scaled_offsets_scanned = null;
                        this.is_scanning_expression = false;
                        return false;
                    }
                    this.points_scanned.addElement(point);
                    this.scaled_offsets_scanned.addElement(scaled_offset);
                    if (null != this.evaluator) {
                        this.expressions_scanned.addElement(expressions);
                    }
                } else {
                    if (4 != this.scanned_token_type) {
                        this.points_scanned = null;
                        this.scaled_offsets_scanned = null;
                        this.is_scanning_expression = false;
                        return false;
                    }
                    this.points_scanned.addElement(null);
                    this.scaled_offsets_scanned.addElement(scaled_offset);
                    if (null != this.evaluator) {
                        this.expressions_scanned.addElement(expressions);
                    }
                }
            } else if (null != this.evaluator) {
                for (index = 0; index < 3; ++index) {
                    if (!this.scan_expression(true)) {
                        this.points_scanned = null;
                        this.scaled_offsets_scanned = null;
                        this.expressions_scanned = null;
                        return false;
                    }
                    this.is_scanning_expression = true;
                    this.is_scanning_after_operand = false;
                    if (!this.is_scanned_expression_numeric) {
                        expressions[index] = this.scanned_expression;
                    }
                    point[index] = this.scanned_number;
                    if (0 != this.scanned_token_type) break;
                    this.scan_token();
                }
                if (index < 2 || 6 != this.scanned_token_type) {
                    this.points_scanned = null;
                    this.scaled_offsets_scanned = null;
                    this.expressions_scanned = null;
                    this.is_scanning_expression = false;
                    return false;
                }
                this.points_scanned.addElement(point);
                this.scaled_offsets_scanned.addElement(scaled_offset);
                this.expressions_scanned.addElement(expressions);
            } else if (22 == this.scanned_token_type) {
                for (index = 0; index < 3 && 22 == this.scanned_token_type; ++index) {
                    point[index] = this.scanned_number;
                    this.scan_token();
                    if (0 != this.scanned_token_type) break;
                    this.scan_token();
                }
                if (index < 2 || 6 != this.scanned_token_type) {
                    this.points_scanned = null;
                    this.scaled_offsets_scanned = null;
                    this.is_scanning_expression = false;
                    return false;
                }
                this.points_scanned.addElement(point);
                this.scaled_offsets_scanned.addElement(scaled_offset);
                if (null != this.evaluator) {
                    this.expressions_scanned.addElement(expressions);
                }
            } else {
                this.points_scanned = null;
                this.scaled_offsets_scanned = null;
                this.is_scanning_expression = false;
                return false;
            }
            if (is_list) {
                this.scan_token();
            }
            ++point_index;
        }
        if (6 != this.scanned_token_type && 4 != this.scanned_token_type) {
            this.points_scanned = null;
            this.scaled_offsets_scanned = null;
            this.is_scanning_expression = false;
            return false;
        }
        this.count_scanned_points = point_index;
        this.scanned_points = new double[this.count_scanned_points][3];
        this.scanned_scaled_offsets = new double[this.count_scanned_points][3];
        if (null != this.evaluator) {
            this.scanned_expressions = new int[this.count_scanned_points][3];
        }
        for (point_index = 0; point_index < this.count_scanned_points; ++point_index) {
            this.scanned_points[point_index] = (double[])this.points_scanned.elementAt(point_index);
            this.scanned_scaled_offsets[point_index] = (double[])this.scaled_offsets_scanned.elementAt(point_index);
            if (null == this.evaluator) continue;
            this.scanned_expressions[point_index] = (int[])this.expressions_scanned.elementAt(point_index);
        }
        this.points_scanned = null;
        this.scaled_offsets_scanned = null;
        this.expressions_scanned = null;
        this.is_scanning_expression = false;
        return true;
    }

    boolean scan_color() {
        this.scanned_color = null;
        if (this.scanned_identifier.equals(name_RGBColor)) {
            if (!this.scan_numbers(true, false) || 3 != this.count_scanned_numbers) {
                return false;
            }
            this.scanned_color = new Color((float)this.scanned_numbers[0], (float)this.scanned_numbers[1], (float)this.scanned_numbers[2]);
        } else if (this.scanned_identifier.equals(name_Hue)) {
            if (!this.scan_numbers(false, false)) {
                return false;
            }
            if (1 == this.count_scanned_numbers) {
                this.scanned_numbers[1] = 1.0;
                this.count_scanned_numbers = 2;
            }
            if (2 == this.count_scanned_numbers) {
                this.scanned_numbers[2] = 1.0;
                this.count_scanned_numbers = 3;
            }
            if (3 != this.count_scanned_numbers) {
                return false;
            }
            this.scanned_numbers[0] = this.scanned_numbers[0] - Math.floor(this.scanned_numbers[0]);
            for (int index = 0; index < 3; ++index) {
                if (0.9999 < this.scanned_numbers[index]) {
                    this.scanned_numbers[index] = 0.9999;
                }
                if (!(1.0E-4 > this.scanned_numbers[index])) continue;
                this.scanned_numbers[index] = 1.0E-4;
            }
            this.scanned_color = Color.getHSBColor((float)this.scanned_numbers[0], (float)this.scanned_numbers[1], (float)this.scanned_numbers[2]);
        } else if (this.scanned_identifier.equals(name_GrayLevel)) {
            if (!this.scan_numbers(true, false) || 1 != this.count_scanned_numbers) {
                return false;
            }
            this.scanned_color = new Color((float)this.scanned_numbers[0], (float)this.scanned_numbers[0], (float)this.scanned_numbers[0]);
        } else if (this.scanned_identifier.equals(name_CMYKColor)) {
            if (!this.scan_numbers(true, false) || 4 != this.count_scanned_numbers) {
                return false;
            }
            this.scanned_color = new Color((float)Math.max(0.0, 1.0 - this.scanned_numbers[0] - this.scanned_numbers[3]), (float)Math.max(0.0, 1.0 - this.scanned_numbers[1] - this.scanned_numbers[3]), (float)Math.max(0.0, 1.0 - this.scanned_numbers[2] - this.scanned_numbers[3]));
        }
        return true;
    }

    public boolean scan_text(Primitive3D primitive, boolean salt_follows) {
        primitive.text = name_Questionmark;
        primitive.front_face_color = null;
        primitive.back_face_color = null;
        primitive.is_filled = false;
        primitive.is_outlined = false;
        if (22 == this.scanned_token_type) {
            primitive.text = String.valueOf(this.scanned_number);
        } else if (23 == this.scanned_token_type) {
            primitive.text = this.scanned_string;
        } else if (21 == this.scanned_token_type) {
            String first_identifier = this.scanned_identifier;
            primitive.text = Primitive3D.text_composite;
            primitive.text_root = this.scan_text_element(null, primitive);
            if (null == primitive.text_root) {
                if (salt_follows) {
                    primitive.text = first_identifier;
                } else {
                    return false;
                }
            }
            primitive.text_root.font_url = primitive.font_url;
        }
        if (salt_follows) {
            this.scan_salt();
        }
        return true;
    }

    TextElement scan_text_element(TextElement parent, Primitive3D primitive) {
        TextElement text_element = new TextElement();
        if (null == parent) {
            text_element.is_root = true;
        } else if (parent.is_held) {
            text_element.is_held = true;
        }
        if (0 == this.scanned_token_type || 4 == this.scanned_token_type || 6 == this.scanned_token_type) {
            text_element.node_type = -1;
            return text_element;
        }
        if (22 == this.scanned_token_type) {
            text_element.node_type = 0;
            text_element.text = String.valueOf(this.scanned_number);
            return text_element;
        }
        if (23 == this.scanned_token_type) {
            text_element.node_type = 0;
            text_element.text = this.scanned_string;
            return text_element;
        }
        if (21 == this.scanned_token_type) {
            if (this.scanned_identifier.equals(name_StyleForm)) {
                TextElement child = null;
                text_element.node_type = 1;
                this.scan_token();
                if (3 != this.scanned_token_type) {
                    return null;
                }
                this.scan_token();
                child = this.scan_text_element(text_element, primitive);
                if (null == child) {
                    return null;
                }
                text_element.children = new Vector();
                text_element.children.addElement(child);
                this.scan_token();
                if (4 == this.scanned_token_type) {
                    return text_element;
                }
                if (0 != this.scanned_token_type) {
                    return null;
                }
                if (!this.scan_font_options() || 4 != this.scanned_token_type) {
                    return null;
                }
                text_element.font_url = this.scanned_font_url;
                if (null != text_element.font_url && null != primitive && null == primitive.font_url) {
                    primitive.font_url = this.scanned_font_url;
                }
                text_element.font_family = this.scanned_font_family;
                text_element.font_weight = this.scanned_font_weight;
                text_element.font_slant = this.scanned_font_slant;
                text_element.font_size = this.scanned_font_size;
                text_element.font_color = this.scanned_font_color;
                text_element.font_background = this.scanned_font_background;
                text_element.font_substitutions = this.scanned_font_substitutions;
                text_element.script_size_multipliers = this.scanned_script_size_multipliers;
                text_element.script_min_size = this.scanned_script_min_size;
                text_element.script_baseline_shift1 = this.scanned_script_baseline_shift1;
                text_element.script_baseline_shift2 = this.scanned_script_baseline_shift2;
                text_element.script_baseline_shift3 = this.scanned_script_baseline_shift3;
                text_element.script_baseline_shift4 = this.scanned_script_baseline_shift4;
                return text_element;
            }
            if (this.scanned_identifier.equals(name_HoldForm)) {
                TextElement child = null;
                text_element.node_type = 2;
                text_element.is_held = true;
                this.scan_token();
                if (3 != this.scanned_token_type) {
                    return null;
                }
                this.scan_token();
                child = this.scan_text_element(text_element, primitive);
                if (null == child) {
                    return null;
                }
                this.scan_token();
                if (4 != this.scanned_token_type) {
                    return null;
                }
                text_element.children = new Vector();
                text_element.children.addElement(child);
                return text_element;
            }
            if (this.scanned_identifier.equals(name_SequenceForm)) {
                TextElement child = null;
                text_element.node_type = 3;
                this.scan_token();
                if (3 != this.scanned_token_type) {
                    return null;
                }
                text_element.children = new Vector();
                this.scanned_token_type = 0;
                while (0 == this.scanned_token_type) {
                    this.scan_token();
                    child = this.scan_text_element(text_element, primitive);
                    if (null == child) {
                        return null;
                    }
                    text_element.children.addElement(child);
                    this.scan_token();
                }
                if (4 != this.scanned_token_type) {
                    return null;
                }
                return text_element;
            }
            if (this.scanned_identifier.equals(name_StringForm)) {
                TextElement new_child;
                TextElement child = null;
                String control_string = null;
                text_element.node_type = 3;
                this.scan_token();
                if (3 != this.scanned_token_type) {
                    return null;
                }
                this.scan_token();
                if (23 != this.scanned_token_type || null == this.scanned_string) {
                    return null;
                }
                control_string = this.scanned_string;
                text_element.children = new Vector();
                int control_char_index = 0;
                int child_index = 0;
                StringBuffer current_string = new StringBuffer();
                int argument_index = 0;
                int next_argument_index = 1;
                do {
                    argument_index = 0;
                    char control_char = control_string.charAt(control_char_index);
                    if (control_char == '`') {
                        argument_index = -1;
                        if (++control_char_index >= control_string.length()) break;
                        if (control_string.charAt(control_char_index) == '.') {
                            current_string.append('`');
                            ++control_char_index;
                            while (control_char_index < control_string.length() && control_string.charAt(control_char_index) != '`') {
                                ++control_char_index;
                            }
                            if (control_char_index >= control_string.length()) break;
                            ++control_char_index;
                        } else if (control_string.charAt(control_char_index) == '`') {
                            argument_index = next_argument_index;
                            ++control_char_index;
                        } else {
                            argument_index = 0;
                            while (control_char_index < control_string.length() && 0 <= digit_characters.indexOf(control_string.charAt(control_char_index))) {
                                argument_index = 10 * argument_index + digit_characters.indexOf(control_string.charAt(control_char_index));
                                ++control_char_index;
                            }
                            if (control_char_index >= control_string.length() || control_string.charAt(control_char_index) != '`') break;
                            ++control_char_index;
                        }
                        if (argument_index <= 0) continue;
                        if (current_string.length() > 0) {
                            new_child = new TextElement();
                            if (text_element.is_held) {
                                new_child.is_held = true;
                            }
                            new_child.node_type = 0;
                            new_child.text = current_string.toString();
                            text_element.children.addElement(new_child);
                            current_string.setLength(0);
                            ++child_index;
                        }
                        TextElement placeholder = new TextElement();
                        placeholder.variable_index = argument_index;
                        if (text_element.is_held) {
                            placeholder.is_held = true;
                        }
                        placeholder.node_type = -2;
                        placeholder.variable_index = argument_index;
                        text_element.children.addElement(placeholder);
                        next_argument_index = argument_index + 1;
                        continue;
                    }
                    current_string.append(control_char);
                    ++control_char_index;
                } while (control_char_index < control_string.length());
                if (current_string.length() > 0) {
                    new_child = new TextElement();
                    if (text_element.is_held) {
                        new_child.is_held = true;
                    }
                    new_child.node_type = 0;
                    new_child.text = current_string.toString();
                    text_element.children.addElement(new_child);
                    current_string.setLength(0);
                }
                int argument_index2 = 1;
                this.scan_token();
                while (0 == this.scanned_token_type) {
                    TextElement placeholder;
                    int other_child_index;
                    this.scan_token();
                    child = this.scan_text_element(text_element, primitive);
                    if (null == child) {
                        return null;
                    }
                    for (other_child_index = 0; other_child_index < text_element.children.size() && (null == (placeholder = (TextElement)text_element.children.elementAt(other_child_index)) || -2 != placeholder.node_type || argument_index2 != placeholder.variable_index); ++other_child_index) {
                    }
                    if (other_child_index < text_element.children.size()) {
                        text_element.children.setElementAt(child, other_child_index);
                    }
                    this.scan_token();
                    ++argument_index2;
                }
                if (4 != this.scanned_token_type) {
                    return null;
                }
                return text_element;
            }
            if (this.scanned_identifier.equals(name_Subscript) || this.scanned_identifier.equals(name_Superscript) || this.scanned_identifier.equals(name_Underscript) || this.scanned_identifier.equals(name_Overscript)) {
                TextElement child = null;
                if (this.scanned_identifier.equals(name_Subscript)) {
                    text_element.node_type = 4;
                } else if (this.scanned_identifier.equals(name_Superscript)) {
                    text_element.node_type = 5;
                }
                if (this.scanned_identifier.equals(name_Underscript)) {
                    text_element.node_type = 8;
                }
                if (this.scanned_identifier.equals(name_Overscript)) {
                    text_element.node_type = 7;
                }
                this.scan_token();
                if (3 != this.scanned_token_type) {
                    return null;
                }
                text_element.children = new Vector();
                this.scan_token();
                child = this.scan_text_element(text_element, primitive);
                if (null == child) {
                    return null;
                }
                text_element.children.addElement(child);
                this.scan_token();
                if (0 != this.scanned_token_type) {
                    return null;
                }
                this.scan_token();
                child = this.scan_text_element(text_element, primitive);
                if (null == child) {
                    return null;
                }
                text_element.children.addElement(child);
                this.scan_token();
                if (4 != this.scanned_token_type) {
                    return null;
                }
                return text_element;
            }
            if (this.scanned_identifier.equals(name_UnderBar)) {
                TextElement child = null;
                text_element.node_type = 8;
                this.scan_token();
                if (3 != this.scanned_token_type) {
                    return null;
                }
                this.scan_token();
                child = this.scan_text_element(text_element, primitive);
                if (null == child) {
                    return null;
                }
                this.scan_token();
                if (4 != this.scanned_token_type) {
                    return null;
                }
                text_element.children = new Vector();
                text_element.children.addElement(child);
                child = new TextElement();
                if (text_element.is_held) {
                    child.is_held = true;
                }
                child.node_type = 0;
                child.text = named_character_Dash;
                text_element.script_baseline_shift3 = -201.0;
                text_element.children.addElement(child);
                return text_element;
            }
            if (this.scanned_identifier.equals(name_OverBar) || this.scanned_identifier.equals(name_OverVector) || this.scanned_identifier.equals(name_OverHat) || this.scanned_identifier.equals(name_OverDot) || this.scanned_identifier.equals(name_OverTilde)) {
                TextElement child = null;
                String overscript = this.scanned_identifier.equals(name_OverBar) ? named_character_Dash : (this.scanned_identifier.equals(name_OverVector) ? named_character_RightArrow : (this.scanned_identifier.equals(name_OverDot) ? named_character_CenterDot : (this.scanned_identifier.equals(name_OverTilde) ? named_character_RawTilde : (this.scanned_identifier.equals(name_OverHat) ? named_character_RawWedge : name_Questionmark))));
                text_element.node_type = 7;
                this.scan_token();
                if (3 != this.scanned_token_type) {
                    return null;
                }
                this.scan_token();
                child = this.scan_text_element(text_element, primitive);
                if (null == child) {
                    return null;
                }
                this.scan_token();
                if (4 != this.scanned_token_type) {
                    return null;
                }
                text_element.children = new Vector();
                text_element.children.addElement(child);
                child = new TextElement();
                if (text_element.is_held) {
                    child.is_held = true;
                }
                child.node_type = 0;
                child.text = overscript;
                text_element.script_baseline_shift4 = -201.0;
                text_element.children.addElement(child);
                return text_element;
            }
            if (this.scanned_identifier.equals(name_Subsuperscript) || this.scanned_identifier.equals(name_Underoverscript)) {
                TextElement child = null;
                if (this.scanned_identifier.equals(name_Subsuperscript)) {
                    text_element.node_type = 6;
                } else if (this.scanned_identifier.equals(name_Underoverscript)) {
                    text_element.node_type = 9;
                }
                this.scan_token();
                if (3 != this.scanned_token_type) {
                    return null;
                }
                text_element.children = new Vector();
                this.scan_token();
                child = this.scan_text_element(text_element, primitive);
                if (null == child) {
                    return null;
                }
                text_element.children.addElement(child);
                this.scan_token();
                if (0 != this.scanned_token_type) {
                    return null;
                }
                this.scan_token();
                child = this.scan_text_element(text_element, primitive);
                if (null == child) {
                    return null;
                }
                text_element.children.addElement(child);
                this.scan_token();
                if (0 != this.scanned_token_type) {
                    return null;
                }
                this.scan_token();
                child = this.scan_text_element(text_element, primitive);
                if (null == child) {
                    return null;
                }
                text_element.children.addElement(child);
                this.scan_token();
                if (4 != this.scanned_token_type) {
                    return null;
                }
                return text_element;
            }
            text_element.node_type = 0;
            text_element.text = this.scanned_identifier;
            if (null != this.evaluator && !text_element.is_held) {
                text_element.variable_index = this.evaluator.getVariableIndex(text_element.text);
            }
            return text_element;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean scan_font_options() {
        this.scanned_font_url = null;
        this.scanned_font_family = null;
        this.scanned_font_weight = -1;
        this.scanned_font_slant = -1;
        this.scanned_font_size = -1;
        this.scanned_font_color = null;
        this.scanned_font_background = null;
        this.scanned_font_substitutions = null;
        this.scanned_script_size_multipliers = -1.0;
        this.scanned_script_min_size = -1;
        this.scanned_script_baseline_shift1 = -101.0;
        this.scanned_script_baseline_shift2 = -101.0;
        this.scanned_script_baseline_shift3 = -101.0;
        this.scanned_script_baseline_shift4 = -101.0;
        this.scan_token();
        while (21 == this.scanned_token_type) {
            if (this.scanned_identifier.equals(name_URL)) {
                this.scan_token();
                if (20 != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (23 != this.scanned_token_type) {
                    return false;
                }
                this.scanned_font_url = this.scanned_string;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_FontFamily)) {
                this.scan_token();
                if (20 != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (23 != this.scanned_token_type) {
                    return false;
                }
                this.scanned_font_family = this.scanned_string;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_FontWeight)) {
                this.scan_token();
                if (20 != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (23 != this.scanned_token_type) {
                    return false;
                }
                this.scanned_font_weight = this.scanned_string.equals(name_Bold) ? 1 : 0;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_FontSlant)) {
                this.scan_token();
                if (20 != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (23 != this.scanned_token_type) {
                    return false;
                }
                this.scanned_font_slant = this.scanned_string.equals(name_Italic) ? 2 : 0;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_FontSize)) {
                this.scan_token();
                if (20 != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (22 != this.scanned_token_type) {
                    return false;
                }
                this.scanned_font_size = (int)this.scanned_number;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_FontColor)) {
                this.scan_token();
                if (20 != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (21 != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_color()) {
                    return false;
                }
                this.scanned_font_color = this.scanned_color;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_Background)) {
                this.scan_token();
                if (20 != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (21 != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_color()) {
                    return false;
                }
                this.scanned_font_background = this.scanned_color;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_FontSubstitutions)) {
                this.scan_token();
                if (20 != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (5 != this.scanned_token_type) {
                    return false;
                }
                this.scanned_font_substitutions = new Vector();
                this.scanned_token_type = 0;
                while (0 == this.scanned_token_type) {
                    this.scan_token();
                    if (6 == this.scanned_token_type) break;
                    if (23 != this.scanned_token_type) {
                        return false;
                    }
                    this.scanned_font_substitutions.addElement(this.scanned_string);
                    this.scan_token();
                    if (20 != this.scanned_token_type) {
                        return false;
                    }
                    this.scan_token();
                    if (23 != this.scanned_token_type) {
                        return false;
                    }
                    this.scanned_font_substitutions.addElement(this.scanned_string);
                    this.scan_token();
                }
                if (6 != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_ScriptSizeMultipliers)) {
                this.scan_token();
                if (20 != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (22 == this.scanned_token_type) {
                    this.scanned_script_size_multipliers = this.scanned_number;
                    this.scan_token();
                } else {
                    if (5 != this.scanned_token_type) return false;
                    this.scan_token();
                    if (22 != this.scanned_token_type) {
                        return false;
                    }
                    this.scanned_script_size_multipliers = this.scanned_number;
                    this.scan_right_bracket();
                    this.scan_token();
                }
            } else if (this.scanned_identifier.equals(name_ScriptMinSize)) {
                this.scan_token();
                if (20 != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (22 != this.scanned_token_type) {
                    return false;
                }
                this.scanned_script_min_size = (int)this.scanned_number;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_ScriptBaselineShifts)) {
                this.scan_token();
                if (20 != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (5 != this.scanned_token_type) {
                    return false;
                }
                int shift_index = 1;
                this.scanned_token_type = 0;
                while (0 == this.scanned_token_type) {
                    this.scan_token();
                    if (21 == this.scanned_token_type) {
                        if (1 == shift_index) {
                            this.scanned_script_baseline_shift1 = 0.6;
                        } else if (2 == shift_index) {
                            this.scanned_script_baseline_shift2 = 0.9;
                        } else if (3 == shift_index) {
                            this.scanned_script_baseline_shift3 = -101.0;
                        } else if (4 == shift_index) {
                            this.scanned_script_baseline_shift4 = -101.0;
                        }
                        this.scan_token();
                    } else {
                        if (22 != this.scanned_token_type) return false;
                        if (1 == shift_index) {
                            this.scanned_script_baseline_shift1 = this.scanned_number;
                        } else if (2 == shift_index) {
                            this.scanned_script_baseline_shift2 = this.scanned_number;
                        } else if (3 == shift_index) {
                            this.scanned_script_baseline_shift3 = this.scanned_number;
                        } else if (4 == shift_index) {
                            this.scanned_script_baseline_shift4 = this.scanned_number;
                        }
                        this.scan_token();
                    }
                    ++shift_index;
                }
                if (6 != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
            } else {
                this.scan_salt();
                this.scan_token();
            }
            if (0 != this.scanned_token_type) return true;
            this.scan_token();
        }
        return true;
    }

    boolean scan_option() {
        this.scanned_nothing = false;
        this.scanning_FaceForm_back = false;
        this.scan_token();
        if (5 == this.scanned_token_type) {
            while (this.scan_option()) {
                this.scan_token();
                if (0 == this.scanned_token_type) continue;
            }
            return 6 == this.scanned_token_type;
        }
        if (21 != this.scanned_token_type) {
            this.scanned_nothing = true;
            return false;
        }
        if (!this.is_scanned_AmbientLight && this.scanned_identifier.equals(name_AmbientLight)) {
            this.is_scanned_AmbientLight = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            Primitive3D primitive = new Primitive3D();
            this.scanning_FaceForm = true;
            if (!this.scan_primitive(primitive)) {
                this.scanning_FaceForm = false;
                return false;
            }
            this.graphics.option_AmbientLight = primitive.front_face_color;
            this.scanning_FaceForm = false;
            return true;
        }
        if (!this.is_scanned_Axes && this.scanned_identifier.equals(name_Axes)) {
            this.is_scanned_Axes = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (21 == this.scanned_token_type) {
                if (this.scanned_identifier.equals(name_True)) {
                    this.graphics.option_Axes[0] = true;
                    this.graphics.option_Axes[1] = true;
                    this.graphics.option_Axes[2] = true;
                }
                return true;
            }
            if (5 == this.scanned_token_type) {
                int index = 0;
                this.scanned_token_type = 0;
                while (index < 3 && 0 == this.scanned_token_type) {
                    this.scan_token();
                    if (21 != this.scanned_token_type) continue;
                    if (this.scanned_identifier.equals(name_True)) {
                        this.graphics.option_Axes[index] = true;
                    }
                    ++index;
                    this.scan_token();
                }
                if (6 == this.scanned_token_type) {
                    return true;
                }
            }
            return false;
        }
        if (!this.is_scanned_AxesLabel && this.scanned_identifier.equals(name_AxesLabel)) {
            this.is_scanned_AxesLabel = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            int index = 2;
            boolean is_list = false;
            if (5 == this.scanned_token_type) {
                index = 0;
                is_list = true;
                this.scan_token();
            } else if (21 == this.scanned_token_type && this.scanned_identifier.equals(name_None)) {
                return true;
            }
            do {
                if (index > 0 && is_list) {
                    this.scan_token();
                }
                if (index > 2) {
                    return false;
                }
                if (21 != this.scanned_token_type || !this.scanned_identifier.equals(name_None)) {
                    Primitive3D primitive;
                    this.graphics.option_AxesLabel[index] = primitive = new Primitive3D();
                    if (!this.scan_text(primitive, false)) {
                        return false;
                    }
                }
                if (!is_list) continue;
                ++index;
                this.scan_token();
            } while (is_list && 0 == this.scanned_token_type);
            return !is_list || 6 == this.scanned_token_type;
        }
        if (!this.is_scanned_AxesStyle && this.scanned_identifier.equals(name_AxesStyle)) {
            this.is_scanned_AxesStyle = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            Primitive3D primitive = new Primitive3D();
            this.scanning_EdgeForm = true;
            this.scanning_AxesStyles = true;
            this.scanned_AxesStyles[0] = null;
            this.scanned_AxesStyles[1] = null;
            this.scanned_AxesStyles[2] = null;
            if (!this.scan_primitive(primitive)) {
                this.scanning_EdgeForm = false;
                this.scanning_AxesStyles = false;
                return false;
            }
            this.scanning_EdgeForm = false;
            this.scanning_AxesStyles = false;
            if (null == this.scanned_AxesStyles[2]) {
                this.scanned_AxesStyles[0] = primitive;
                this.scanned_AxesStyles[1] = primitive;
                this.scanned_AxesStyles[2] = primitive;
            }
            for (int index = 0; index < 3; ++index) {
                primitive = this.scanned_AxesStyles[index];
                if (null != primitive) {
                    primitive.original_thickness = primitive.original_edge_thickness;
                    primitive.is_absolute_thickness = primitive.is_absolute_edge_thickness;
                    primitive.standard_color = primitive.edge_color;
                }
                this.graphics.option_AxesStyle[index] = primitive;
            }
            return true;
        }
        if (!this.is_scanned_AxesEdge && this.scanned_identifier.equals(name_AxesEdge)) {
            this.is_scanned_AxesEdge = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (21 == this.scanned_token_type) {
                if (!this.scanned_identifier.equals(name_Automatic)) {
                    this.graphics.option_AxesEdge[0] = -2;
                    this.graphics.option_AxesEdge[1] = -2;
                    this.graphics.option_AxesEdge[2] = -2;
                }
                return true;
            }
            if (5 != this.scanned_token_type) {
                return false;
            }
            int index = 0;
            do {
                this.scan_token();
                if (21 == this.scanned_token_type) {
                    if (!this.scanned_identifier.equals(name_Automatic)) {
                        this.graphics.option_AxesEdge[index] = -2;
                    }
                } else if (5 == this.scanned_token_type) {
                    this.scan_token();
                    if (22 != this.scanned_token_type) {
                        return false;
                    }
                    int edge_code = 0;
                    if (this.scanned_number > 0.0) {
                        edge_code = 1;
                    }
                    this.scan_token();
                    if (0 != this.scanned_token_type) {
                        return false;
                    }
                    this.scan_token();
                    if (22 != this.scanned_token_type) {
                        return false;
                    }
                    if (this.scanned_number > 0.0) {
                        edge_code += 2;
                    }
                    this.scan_token();
                    if (6 != this.scanned_token_type) {
                        return false;
                    }
                    this.graphics.option_AxesEdge[index] = edge_code;
                } else {
                    return false;
                }
                this.scan_token();
            } while (++index < 3 && 0 == this.scanned_token_type);
            return 6 == this.scanned_token_type;
        }
        if (!this.is_scanned_Ticks && this.scanned_identifier.equals(name_Ticks)) {
            this.is_scanned_Ticks = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (21 == this.scanned_token_type) {
                if (this.scanned_identifier.equals(name_None)) {
                    this.graphics.option_Ticks = new Vector[3];
                    return true;
                }
                if (this.scanned_identifier.equals(name_Automatic)) {
                    this.graphics.option_Ticks = new Vector[3];
                    for (int index = 0; index < 3; ++index) {
                        this.graphics.option_Ticks[index] = new Vector();
                    }
                    return true;
                }
                return false;
            }
            if (5 == this.scanned_token_type) {
                this.graphics.option_Ticks = new Vector[3];
                for (int index = 0; index < 3; ++index) {
                    this.graphics.option_Ticks[index] = null;
                }
                int axis_index = 0;
                this.scanned_token_type = 0;
                while (0 == this.scanned_token_type) {
                    this.scan_token();
                    if (21 == this.scanned_token_type) {
                        if (this.scanned_identifier.equals(name_Automatic)) {
                            this.graphics.option_Ticks[axis_index] = new Vector();
                        } else if (!this.scanned_identifier.equals(name_None)) {
                            return false;
                        }
                    } else {
                        if (5 != this.scanned_token_type) {
                            return false;
                        }
                        this.graphics.option_Ticks[axis_index] = new Vector();
                        this.scanned_token_type = 0;
                        while (0 == this.scanned_token_type) {
                            Primitive3D primitive = new Primitive3D();
                            primitive.front_specular_exponent = 0.01;
                            primitive.back_specular_exponent = 0.0;
                            this.scan_token();
                            if (22 == this.scanned_token_type) {
                                primitive.original_point_size = this.scanned_number;
                                primitive.text = Double.toString(this.scanned_number);
                            } else if (5 == this.scanned_token_type) {
                                this.scan_token();
                                if (22 != this.scanned_token_type) {
                                    return false;
                                }
                                double tick_mark_position = this.scanned_number;
                                this.scan_token();
                                if (0 == this.scanned_token_type) {
                                    this.scan_token();
                                    if (!this.scan_text(primitive, false)) {
                                        return false;
                                    }
                                    this.scan_token();
                                    if (0 == this.scanned_token_type) {
                                        this.scan_token();
                                        if (22 == this.scanned_token_type) {
                                            primitive.front_specular_exponent = this.scanned_number / 2.0;
                                            primitive.back_specular_exponent = this.scanned_number / 2.0;
                                        } else if (5 == this.scanned_token_type) {
                                            this.scan_token();
                                            if (22 != this.scanned_token_type) {
                                                return false;
                                            }
                                            primitive.front_specular_exponent = this.scanned_number;
                                            this.scan_token();
                                            if (0 != this.scanned_token_type) {
                                                return false;
                                            }
                                            this.scan_token();
                                            if (22 != this.scanned_token_type) {
                                                return false;
                                            }
                                            primitive.back_specular_exponent = this.scanned_number;
                                            this.scan_token();
                                            if (6 != this.scanned_token_type) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                        this.scan_token();
                                        if (0 == this.scanned_token_type) {
                                            this.scanning_EdgeForm = true;
                                            if (!this.scan_primitive(primitive)) {
                                                this.scanning_EdgeForm = false;
                                                return false;
                                            }
                                            primitive.original_thickness = primitive.original_edge_thickness;
                                            primitive.is_absolute_thickness = primitive.is_absolute_edge_thickness;
                                            primitive.standard_color = primitive.edge_color;
                                            this.scanning_EdgeForm = false;
                                            this.scan_token();
                                        }
                                    }
                                } else {
                                    primitive.text = Double.toString(tick_mark_position);
                                }
                                primitive.original_point_size = tick_mark_position;
                                if (6 != this.scanned_token_type) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                            if (this.graphics.ticks_max_in_length[axis_index] < primitive.front_specular_exponent) {
                                this.graphics.ticks_max_in_length[axis_index] = primitive.front_specular_exponent;
                            }
                            if (this.graphics.ticks_max_out_length[axis_index] < primitive.back_specular_exponent) {
                                this.graphics.ticks_max_out_length[axis_index] = primitive.back_specular_exponent;
                            }
                            this.graphics.option_Ticks[axis_index].addElement(primitive);
                            this.scan_token();
                        }
                        if (6 != this.scanned_token_type) {
                            return false;
                        }
                    }
                    ++axis_index;
                    this.scan_token();
                }
                return 6 == this.scanned_token_type;
            }
            return false;
        }
        if (!this.is_scanned_PlotLabel && this.scanned_identifier.equals(name_PlotLabel)) {
            Primitive3D primitive;
            this.is_scanned_PlotLabel = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (21 == this.scanned_token_type && this.scanned_identifier.equals(name_None)) {
                return true;
            }
            this.graphics.option_PlotLabel = primitive = new Primitive3D();
            return this.scan_text(primitive, false);
        }
        if (!this.is_scanned_Background && this.scanned_identifier.equals(name_Background)) {
            this.is_scanned_Background = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            Primitive3D primitive = new Primitive3D();
            this.scanning_FaceForm = true;
            if (!this.scan_primitive(primitive)) {
                this.scanning_FaceForm = false;
                return false;
            }
            this.graphics.option_Background = primitive.front_face_color;
            this.scanning_FaceForm = false;
            return true;
        }
        if (!this.is_scanned_DefaultColor && this.scanned_identifier.equals(name_DefaultColor)) {
            this.is_scanned_DefaultColor = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            Primitive3D primitive = new Primitive3D();
            this.scanning_FaceForm = true;
            if (!this.scan_primitive(primitive)) {
                this.scanning_FaceForm = false;
                return false;
            }
            this.graphics.option_DefaultColor = primitive.front_face_color;
            this.scanning_FaceForm = false;
            return true;
        }
        if (!this.is_scanned_BoxStyle && this.scanned_identifier.equals(name_BoxStyle)) {
            this.is_scanned_BoxStyle = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            Primitive3D primitive = new Primitive3D();
            this.scanning_EdgeForm = true;
            if (!this.scan_primitive(primitive)) {
                this.scanning_EdgeForm = false;
                return false;
            }
            primitive.original_thickness = primitive.original_edge_thickness;
            primitive.is_absolute_thickness = primitive.is_absolute_edge_thickness;
            primitive.standard_color = primitive.edge_color;
            this.graphics.option_BoxStyle = primitive;
            this.scanning_EdgeForm = false;
            return true;
        }
        if (!this.is_scanned_Boxed && this.scanned_identifier.equals(name_Boxed)) {
            this.is_scanned_Boxed = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (21 == this.scanned_token_type) {
                if (this.scanned_identifier.equals(name_False)) {
                    this.graphics.option_Boxed = false;
                }
                return true;
            }
            return false;
        }
        if (!this.is_scanned_Lighting && this.scanned_identifier.equals(name_Lighting)) {
            this.is_scanned_Lighting = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (21 == this.scanned_token_type) {
                if (this.scanned_identifier.equals(name_False)) {
                    this.graphics.option_Lighting = false;
                }
                return true;
            }
            return false;
        }
        if (!this.is_scanned_BoxRatios && this.scanned_identifier.equals(name_BoxRatios)) {
            this.is_scanned_BoxRatios = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            if (this.scan_numbers(false, true) && 3 == this.count_scanned_numbers) {
                this.graphics.option_BoxRatios = new double[3];
                this.graphics.option_BoxRatios[0] = this.scanned_numbers[0];
                this.graphics.option_BoxRatios[1] = this.scanned_numbers[1];
                this.graphics.option_BoxRatios[2] = this.scanned_numbers[2];
                return true;
            }
            this.scan_salt();
            return true;
        }
        if (!this.is_scanned_PlotRange && this.scanned_identifier.equals(name_PlotRange)) {
            this.is_scanned_PlotRange = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (5 != this.scanned_token_type) {
                this.scan_salt();
                return true;
            }
            double[][] new_option_PlotRange = new double[][]{{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY}, {Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY}, {Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY}};
            int axes_index = 0;
            boolean is_only_z = false;
            this.scan_token();
            if (22 == this.scanned_token_type) {
                axes_index = 2;
                is_only_z = true;
            } else if (5 == this.scanned_token_type) {
                this.scan_token();
            } else if (21 != this.scanned_token_type) {
                return false;
            }
            while (axes_index < 3) {
                if (21 != this.scanned_token_type) {
                    for (int index = 0; index < 2; ++index) {
                        if (22 != this.scanned_token_type) {
                            return false;
                        }
                        new_option_PlotRange[axes_index][index] = this.scanned_number;
                        this.scan_token();
                        if (0 != index) continue;
                        this.scan_token();
                    }
                    if (6 != this.scanned_token_type) {
                        return false;
                    }
                }
                if (!is_only_z) {
                    this.scan_token();
                    if (axes_index < 2) {
                        this.scan_token();
                        if (5 == this.scanned_token_type) {
                            this.scan_token();
                        }
                    }
                }
                ++axes_index;
            }
            if (6 != this.scanned_token_type) {
                return false;
            }
            this.graphics.option_PlotRange = new_option_PlotRange;
            return true;
        }
        if (!this.is_scanned_LightSources && this.scanned_identifier.equals(name_LightSources)) {
            this.is_scanned_LightSources = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (5 != this.scanned_token_type) {
                this.scan_salt();
                return true;
            }
            this.graphics.option_LightSources_vectors = new Vector();
            this.graphics.option_LightSources_colors = new Vector();
            this.scanned_token_type = 0;
            while (0 == this.scanned_token_type) {
                double[] new_light_vector = new double[3];
                this.scan_token();
                if (5 != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_numbers(false, true) || 3 != this.count_scanned_numbers) {
                    return false;
                }
                double vector_length = Math.sqrt(this.scanned_numbers[0] * this.scanned_numbers[0] + this.scanned_numbers[1] * this.scanned_numbers[1] + this.scanned_numbers[2] * this.scanned_numbers[2]);
                new_light_vector[0] = this.scanned_numbers[0] / vector_length;
                new_light_vector[1] = this.scanned_numbers[1] / vector_length;
                new_light_vector[2] = this.scanned_numbers[2] / vector_length;
                this.scan_token();
                if (0 != this.scanned_token_type) {
                    return false;
                }
                Primitive3D primitive = new Primitive3D();
                this.scanning_FaceForm = true;
                if (!this.scan_primitive(primitive) || null == primitive.front_face_color) {
                    this.scanning_FaceForm = false;
                    return false;
                }
                this.scanning_FaceForm = false;
                this.graphics.option_LightSources_vectors.addElement(new_light_vector);
                this.graphics.option_LightSources_colors.addElement(primitive.front_face_color);
                this.scan_token();
                if (6 != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
            }
            return 6 == this.scanned_token_type;
        }
        if (!this.is_scanned_ViewPoint && this.scanned_identifier.equals(name_ViewPoint)) {
            this.is_scanned_ViewPoint = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            if (!this.scan_numbers(false, true) || 3 != this.count_scanned_numbers) {
                return false;
            }
            this.graphics.option_ViewPoint = new double[3];
            this.graphics.option_ViewPoint[0] = this.scanned_numbers[0];
            this.graphics.option_ViewPoint[1] = this.scanned_numbers[1];
            this.graphics.option_ViewPoint[2] = this.scanned_numbers[2];
            return true;
        }
        if (!this.is_scanned_ViewVertical && this.scanned_identifier.equals(name_ViewVertical)) {
            this.is_scanned_ViewVertical = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            if (!this.scan_numbers(false, true) || 3 != this.count_scanned_numbers) {
                return false;
            }
            this.graphics.option_ViewVertical = new double[3];
            this.graphics.option_ViewVertical[0] = this.scanned_numbers[0];
            this.graphics.option_ViewVertical[1] = this.scanned_numbers[1];
            this.graphics.option_ViewVertical[2] = this.scanned_numbers[2];
            return true;
        }
        if (!this.is_scanned_TextStyle && this.scanned_identifier.equals(name_TextStyle)) {
            this.is_scanned_TextStyle = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (21 == this.scanned_token_type) {
                return true;
            }
            if (5 != this.scanned_token_type) {
                return false;
            }
            if (!this.scan_font_options() || 6 != this.scanned_token_type) {
                return false;
            }
            this.graphics.option_TextStyle_font_url = this.scanned_font_url;
            this.graphics.option_TextStyle_font_family = this.scanned_font_family;
            this.graphics.option_TextStyle_font_weight = this.scanned_font_weight;
            this.graphics.option_TextStyle_font_slant = this.scanned_font_slant;
            this.graphics.option_TextStyle_font_size = this.scanned_font_size;
            this.graphics.option_TextStyle_font_color = this.scanned_font_color;
            this.graphics.option_TextStyle_font_background = this.scanned_font_background;
            if (null != this.scanned_font_substitutions) {
                this.graphics.option_TextStyle_font_substitutions = this.scanned_font_substitutions;
            }
            this.graphics.option_TextStyle_script_size_multipliers = this.scanned_script_size_multipliers;
            this.graphics.option_TextStyle_script_min_size = this.scanned_script_min_size;
            this.graphics.option_TextStyle_script_baseline_shift1 = this.scanned_script_baseline_shift1;
            this.graphics.option_TextStyle_script_baseline_shift2 = this.scanned_script_baseline_shift2;
            this.graphics.option_TextStyle_script_baseline_shift3 = this.scanned_script_baseline_shift3;
            this.graphics.option_TextStyle_script_baseline_shift4 = this.scanned_script_baseline_shift4;
            return true;
        }
        if ((!this.is_scanned_AnimationDisplayTime || this.scanning_animation_option) && this.scanned_identifier.equals(name_AnimationDisplayTime)) {
            int variable_index;
            this.is_scanned_AnimationDisplayTime = true;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (22 == this.scanned_token_type) {
                this.graphics.option_AnimationDisplayTime = this.scanned_number;
                this.graphics.option_AnimationDisplayTimeString = null;
                return true;
            }
            if (21 == this.scanned_token_type && null != this.evaluator && (variable_index = this.evaluator.getVariableIndex(this.scanned_identifier)) >= 0) {
                this.graphics.option_AnimationDisplayTime = 0.05;
                this.graphics.option_AnimationDisplayTimeString = this.scanned_identifier;
                return true;
            }
            return false;
        }
        if (this.scanning_animation_option && this.scanned_identifier.equals(name_AnimationDirection)) {
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (21 != this.scanned_token_type) {
                return false;
            }
            if (this.scanned_identifier.equals(name_Forward)) {
                this.scanned_AnimationDirection = 1;
            } else if (this.scanned_identifier.equals(name_Backward)) {
                this.scanned_AnimationDirection = -1;
            } else if (this.scanned_identifier.equals(name_ForwardBackward)) {
                this.scanned_AnimationDirection = 0;
            }
            return true;
        }
        this.scan_salt();
        return ',' == this.current_char || '}' == this.current_char || ']' == this.current_char;
    }

    public boolean scan_independent_variables() {
        if (null == this.evaluator) {
            return false;
        }
        this.evaluator.clearAllVariables();
        this.text_index = -1;
        this.scan_token();
        if (5 != this.scanned_token_type) {
            return 25 == this.scanned_token_type;
        }
        this.scanned_token_type = 0;
        while (0 == this.scanned_token_type) {
            this.scan_token();
            if (21 != this.scanned_token_type) break;
            String variable_name = this.scanned_identifier;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (22 != this.scanned_token_type) {
                return false;
            }
            double variable_value = this.scanned_number;
            if (!this.evaluator.addIndependentVariable(variable_name, variable_value)) {
                return false;
            }
            this.scan_token();
        }
        return 6 == this.scanned_token_type;
    }

    public boolean scan_dependent_variables() {
        if (null == this.evaluator) {
            return false;
        }
        this.text_index = -1;
        this.scan_token();
        if (5 != this.scanned_token_type) {
            return 25 == this.scanned_token_type;
        }
        this.scanned_token_type = 0;
        while (0 == this.scanned_token_type) {
            this.scan_token();
            if (21 != this.scanned_token_type) break;
            String variable_name = this.scanned_identifier;
            this.scan_token();
            if (20 != this.scanned_token_type) {
                return false;
            }
            this.is_scanning_expression = true;
            this.is_scanning_after_operand = false;
            this.scan_token();
            if (!this.scan_expression(false)) {
                return false;
            }
            if (!(this.is_scanned_expression_numeric ? !this.evaluator.addDependentVariable(variable_name, this.scanned_number, -1) : !this.evaluator.addDependentVariable(variable_name, 0.0, this.scanned_expression))) continue;
            return false;
        }
        return 6 == this.scanned_token_type;
    }

    public int left_precedence(int token) {
        switch (token) {
            case 0: {
                return 1;
            }
            case 35: {
                return 3;
            }
            case 36: {
                return 5;
            }
            case 33: {
                return 8;
            }
            case 32: {
                return 10;
            }
            case 34: {
                return 12;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return 14;
            }
            case 7: {
                return 16;
            }
            case 8: {
                return 16;
            }
            case 9: {
                return 18;
            }
            case 10: {
                return 18;
            }
            case 11: {
                return 18;
            }
            case 27: 
            case 28: {
                return 18;
            }
            case 12: 
            case 13: {
                return 20;
            }
            case 30: {
                return 22;
            }
            case 1: 
            case 3: {
                return 0;
            }
            case 2: 
            case 4: {
                return 101;
            }
            case 21: 
            case 22: {
                return 101;
            }
            case 24: 
            case 26: {
                return 0;
            }
        }
        return -1;
    }

    public int right_precedence(int token) {
        switch (token) {
            case 0: {
                return 2;
            }
            case 35: {
                return 4;
            }
            case 36: {
                return 6;
            }
            case 33: {
                return 7;
            }
            case 32: {
                return 9;
            }
            case 34: {
                return 13;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return 15;
            }
            case 7: {
                return 15;
            }
            case 8: {
                return 15;
            }
            case 9: {
                return 17;
            }
            case 10: {
                return 17;
            }
            case 11: {
                return 19;
            }
            case 27: 
            case 28: {
                return 19;
            }
            case 12: 
            case 13: {
                return 19;
            }
            case 30: {
                return 23;
            }
            case 1: 
            case 3: {
                return 100;
            }
            case 2: 
            case 4: {
                return 0;
            }
            case 21: 
            case 22: {
                return 100;
            }
            case 24: 
            case 26: {
                return 0;
            }
        }
        return -1;
    }

    public boolean scan_expression(boolean evaluate) {
        double current_value;
        Stack<ExpressionElement> stack = new Stack<ExpressionElement>();
        Vector<ExpressionElement> program = new Vector<ExpressionElement>();
        int nesting = 0;
        int relation_operators_count = 0;
        boolean is_scanning_first_argument_of_set = false;
        Parser.arguments_counts[0] = 1;
        if (null == this.evaluator) {
            System.out.println("LiveGraphics3D: internal scanning error (no evaluator in scan_expression)");
            return false;
        }
        this.is_scanning_expression = true;
        this.is_scanning_after_operand = false;
        this.scanned_expression = -1;
        this.is_scanned_expression_numeric = false;
        this.expression_token();
        int current_token = this.scanned_token_type;
        if (21 == current_token) {
            current_value = 0.5 + (double)this.evaluator.getVariableIndex(this.scanned_identifier);
            if (current_value < 0.0) {
                this.is_scanning_expression = false;
                return false;
            }
            this.is_scanning_after_operand = true;
        } else if (30 == current_token) {
            current_value = 0.5 + (double)this.scanned_function_identifier;
            if (current_value < 0.0) {
                this.is_scanning_expression = false;
                return false;
            }
            if (113 == this.scanned_function_identifier) {
                is_scanning_first_argument_of_set = true;
            }
        } else if (22 == current_token) {
            if (this.scanned_number >= 0.0) {
                current_value = this.scanned_number;
                this.is_scanning_after_operand = true;
            } else {
                System.out.println("LiveGraphics3D: Internal scanning error! (resuming)");
                stack.push(new ExpressionElement(28, 0.0, nesting));
                current_value = -this.scanned_number;
                this.is_scanning_after_operand = true;
            }
        } else {
            current_value = 0.0;
        }
        if (1 == current_token || 3 == current_token) {
            Parser.arguments_counts[++nesting] = 1;
        } else if (2 == current_token || 4 == current_token) {
            if (--nesting < 0) {
                this.is_scanning_expression = false;
                return false;
            }
        } else if (0 == current_token) {
            if (0 == arguments_counts[nesting]) {
                this.is_scanning_expression = false;
                return false;
            }
            Parser.arguments_counts[nesting] = arguments_counts[nesting] + 1;
        } else if (0 == arguments_counts[nesting]) {
            Parser.arguments_counts[nesting] = 1;
        }
        if (nesting == 0 && 0 == current_token || 6 == current_token) {
            current_token = 24;
        }
        if (this.left_precedence(current_token) < 0 || this.right_precedence(current_token) < 0) {
            this.is_scanning_expression = false;
            return false;
        }
        while (true) {
            int previous_token;
            if ((previous_token = !stack.empty() ? ((ExpressionElement)stack.peek()).token : 26) == 24 && current_token == 24) break;
            if (this.left_precedence(previous_token) <= this.right_precedence(current_token)) {
                stack.push(new ExpressionElement(current_token, current_value, nesting));
                if (24 == current_token) continue;
                this.scan_token();
                this.expression_token();
                if (36 == this.scanned_token_type && 21 != current_token) {
                    this.is_scanning_expression = false;
                    return false;
                }
                current_token = this.scanned_token_type;
                if (21 == current_token) {
                    current_value = 0.5 + (double)this.evaluator.getVariableIndex(this.scanned_identifier);
                    if (current_value < 0.0) {
                        this.is_scanning_expression = false;
                        return false;
                    }
                    if (is_scanning_first_argument_of_set) {
                        current_token = 22;
                    }
                } else if (30 == current_token) {
                    current_value = 0.5 + (double)this.scanned_function_identifier;
                    if (current_value < 0.0) {
                        this.is_scanning_expression = false;
                        return false;
                    }
                    if (113 == this.scanned_function_identifier) {
                        is_scanning_first_argument_of_set = true;
                    }
                } else if (22 == current_token) {
                    current_value = this.scanned_number;
                } else if (36 == current_token) {
                    if (!this.evaluator.isVariableIndependent((int)current_value)) {
                        this.is_scanning_expression = false;
                        return false;
                    }
                } else {
                    current_value = 0.0;
                }
                if (1 == current_token || 3 == current_token) {
                    Parser.arguments_counts[++nesting] = 0;
                } else if (2 == current_token || 4 == current_token) {
                    is_scanning_first_argument_of_set = false;
                    if (--nesting < 0) {
                        this.is_scanning_expression = false;
                        return false;
                    }
                } else if (0 == current_token) {
                    is_scanning_first_argument_of_set = false;
                    if (0 == arguments_counts[nesting]) {
                        this.is_scanning_expression = false;
                        return false;
                    }
                    Parser.arguments_counts[nesting] = arguments_counts[nesting] + 1;
                } else if (0 == arguments_counts[nesting]) {
                    Parser.arguments_counts[nesting] = 1;
                }
                if (nesting == 0 && 0 == current_token || 6 == current_token) {
                    current_token = 24;
                }
                if (this.left_precedence(current_token) >= 0 && this.right_precedence(current_token) >= 0) continue;
                this.is_scanning_expression = false;
                return false;
            }
            ExpressionElement top_element = null;
            do {
                top_element = (ExpressionElement)stack.pop();
                if (top_element.token == 30) {
                    top_element.value += (double)(1024 * arguments_counts[top_element.nesting + 1]);
                }
                if (top_element.token != 1 && top_element.token != 2 && top_element.token != 3 && top_element.token != 4 && top_element.token != 0) {
                    program.addElement(top_element);
                }
                previous_token = !stack.empty() ? ((ExpressionElement)stack.peek()).token : 26;
                if (16 == top_element.token || 17 == top_element.token || 14 == top_element.token || 15 == top_element.token || 18 == top_element.token || 19 == top_element.token) {
                    ++relation_operators_count;
                    if (16 == previous_token || 17 == previous_token || 14 == previous_token || 15 == previous_token || 18 == previous_token || 19 == previous_token) continue;
                    program.addElement(new ExpressionElement(31, relation_operators_count, 0));
                    continue;
                }
                relation_operators_count = 0;
            } while (26 != previous_token && this.left_precedence(previous_token) >= this.right_precedence(top_element.token));
        }
        program.addElement(new ExpressionElement(24, 0.0, nesting));
        if (program.size() < 2) {
            this.is_scanning_expression = false;
            return false;
        }
        if (2 == program.size() && 22 == ((ExpressionElement)program.elementAt((int)0)).token) {
            this.scanned_number = ((ExpressionElement)program.elementAt((int)0)).value;
            this.is_scanned_expression_numeric = true;
        } else if (3 == program.size() && 22 == ((ExpressionElement)program.elementAt((int)0)).token && 28 == ((ExpressionElement)program.elementAt((int)1)).token) {
            this.scanned_number = -((ExpressionElement)program.elementAt((int)0)).value;
            this.is_scanned_expression_numeric = true;
        } else if (3 == program.size() && 22 == ((ExpressionElement)program.elementAt((int)0)).token && 27 == ((ExpressionElement)program.elementAt((int)1)).token) {
            this.scanned_number = ((ExpressionElement)program.elementAt((int)0)).value;
            this.is_scanned_expression_numeric = true;
        } else {
            int[] tokens_list = new int[program.size()];
            double[] values_list = new double[program.size()];
            for (int index = 0; index < program.size(); ++index) {
                tokens_list[index] = ((ExpressionElement)program.elementAt((int)index)).token;
                values_list[index] = ((ExpressionElement)program.elementAt((int)index)).value;
            }
            this.scanned_expression = this.evaluator.addExpression(new Expression(this.evaluator, program.size(), tokens_list, values_list));
            if (evaluate) {
                if (!this.evaluator.getExpression(this.scanned_expression).evaluate()) {
                    this.is_scanning_expression = false;
                    return false;
                }
                this.scanned_number = this.evaluator.getExpression((int)this.scanned_expression).current_value;
            } else {
                this.scanned_number = 0.0;
            }
        }
        this.is_scanning_expression = false;
        return true;
    }

    public void expression_token() {
        if (this.scanned_token_type != 21) {
            return;
        }
        if (this.scanned_left_bracket) {
            this.scanned_token_type = 30;
            this.is_scanning_after_operand = false;
            this.scanned_function_identifier = -1;
            for (int function_id = 0; function_id < 114; ++function_id) {
                if (!this.scanned_identifier.equals(function_names[function_id])) continue;
                this.scanned_function_identifier = function_id;
                break;
            }
            return;
        }
        if (this.scanned_identifier.equals(name_E)) {
            this.scanned_number = Math.E;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_Pi)) {
            this.scanned_number = Math.PI;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_GoldenRatio)) {
            this.scanned_number = 1.618033988749895;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_EulerGamma)) {
            this.scanned_number = 0.5772156649015329;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_Degree)) {
            this.scanned_number = Math.PI / 180;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_Catalan)) {
            this.scanned_number = 0.915965594177219;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_Khinchin)) {
            this.scanned_number = 2.6854520010653062;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_Glaisher)) {
            this.scanned_number = 1.2824271291006226;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_True)) {
            this.scanned_number = 1.0;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_False)) {
            this.scanned_number = 0.0;
            this.scanned_token_type = 22;
            return;
        }
        if (this.scanned_identifier.equals(name_I) || this.scanned_identifier.equals(name_Infinity) || this.scanned_identifier.equals(name_Indeterminate) || this.scanned_identifier.equals(name_ComplexInfinity)) {
            this.scanned_number = Double.NaN;
            this.scanned_token_type = 22;
            return;
        }
    }
}

