% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vroom_write.R
\name{vroom_format}
\alias{vroom_format}
\title{Convert a data frame to a delimited string}
\usage{
vroom_format(x, delim = "\\t", na = "NA", col_names = TRUE,
  escape = c("double", "backslash", "none"), quote = c("needed", "all",
  "none"), bom = FALSE)
}
\arguments{
\item{x}{A data frame to write to disk}

\item{delim}{One of more characters used to delimiter fields within a
record. If \code{NULL} the delimiter is guessed from the set of \code{c(",", "\\t", " ", "|", ":", ";", "\\n")}.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{col_names}{Either \code{TRUE}, \code{FALSE} or a character vector
of column names.

If \code{TRUE}, the first row of the input will be used as the column
names, and will not be included in the data frame. If \code{FALSE}, column
names will be generated automatically: X1, X2, X3 etc.

If \code{col_names} is a character vector, the values will be used as the
names of the columns, and the first row of the input will be read into
the first row of the output data frame.

Missing (\code{NA}) column names will generate a warning, and be filled
in with dummy names \code{X1}, \code{X2} etc. Duplicate column names
will generate a warning and be made unique with a numeric prefix.}

\item{escape}{The type of escape to use when quotes are in the data.
\itemize{
\item \code{double} - quotes are escaped by doubling them.
\item \code{backslash} - quotes are escaped by a preceding backslash.
\item \code{none} - quotes are not escaped.
}}

\item{quote}{How to handle fields which contain characters that need to be quoted.
\itemize{
\item \code{needed} - Only quote fields which need them.
\item \code{all} - Quote all fields.
\item \code{none} - Never quote fields.
}}

\item{bom}{If \code{TRUE} add a UTF-8 BOM at the beginning of the file. This is
recommended when saving data for consumption by excel, as it will force
excel to read the data with the correct encoding (UTF-8)}
}
\description{
This is equivalent to \code{\link[=vroom_write]{vroom_write()}}, but instead of writing to
disk, it returns a string. It is primarily useful for examples and for
testing.
}
