% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vsd.R
\name{vsd}
\alias{vsd}
\alias{vsd.formula}
\alias{vsd.Surv}
\alias{vsd.coxph}
\alias{vsd.survfit}
\alias{vsd.survfitcox}
\alias{vsd.flexsurvreg}
\title{Visualizing Survival Data}
\usage{
vsd(
  model,
  data = NULL,
  .interactive = FALSE,
  .include = c("fit", "parametric", "forest", "residuals", "hazard"),
  .arguments = list(),
  ...
)

\method{vsd}{formula}(
  model,
  data = NULL,
  .interactive = FALSE,
  .include = c("fit", "hazard"),
  .arguments = list(),
  ...
)

\method{vsd}{Surv}(
  model,
  data = NULL,
  .interactive = FALSE,
  .include = c("fit", "hazard"),
  .arguments = list(),
  ...
)

\method{vsd}{coxph}(
  model,
  data = NULL,
  .interactive = FALSE,
  .include = c("fit", "forest", "residuals", "hazard"),
  .arguments = list(),
  ...
)

\method{vsd}{survfit}(
  model,
  data = NULL,
  .interactive = FALSE,
  .include = c("fit", "hazard"),
  .arguments = list(),
  ...
)

\method{vsd}{survfitcox}(
  model,
  data = NULL,
  .interactive = FALSE,
  .include = c("fit", "forest", "residuals", "hazard"),
  .arguments = list(),
  ...
)

\method{vsd}{flexsurvreg}(
  model,
  data = NULL,
  .interactive = FALSE,
  .include = c("fit", "parametric", "hazard"),
  .arguments = list(),
  ...
)
}
\arguments{
\item{model}{The survival model, or data structure, to generate graphics from}

\item{data}{Dataframe from where the model fetches its variables, if left
blank will be extracted from the model, if possible}

\item{.interactive}{Allows to explore the generated graphs before returning
(use with \href{https://plotly.com/r/}{plotly} package for best results)}

\item{.include}{Graph types to output if relevant, defaults to all possible}

\item{.arguments}{Collection of list of arguments, indexed by the specific
type of graph they should be passed to, has priority over \dots}

\item{...}{Miscellaneous arguments, passed to ALL graphs}
}
\value{
A list of ggplot2 graphs and/or list of graphs, relevant to the model
}
\description{
This function outputs renders of the inputted survival data analysis data
and/or model, and their components, into a graphically pleasing output, under
the \link{ggplot2} format.
}
\details{
Depending on the kind of model passed to the function, the kind of generated
graphics might vary, but usually an estimation of the survival and risk
curves (depending if the model has covariables) is expected. The kinds of
graphics that can be created according to a specific R object are detailed on
Usage on \code{.include}'s definition, but non-relevant graphics can be requested
without error, as the function ignores them silently.

Extra options for each graph kind can be passed to either all created
graphics, by having them as generic arguments, or to specific graphic types,
using a list in \code{.arguments}. Arguments are filtered, so that generic
arguments aren't applied if a graphic kind wouldn't use them. As an example,\preformatted{vsd(model, data, 
    .arguments = list(fit = (size = 3, xlab = "Weeks")),
    xlab = "Days") 
}

would set all graphics that have an label on the x axis to
"Days", except the \code{fit} graph, which would have "Weeks" instead.
}
\section{Methods (by class)}{
\itemize{
\item \code{formula}: Wraps \code{Surv(...) ~ (...)} in a survfit object (Kaplan-Meier
model)

\item \code{Surv}: Wraps \code{\link[=Surv]{Surv()}} in a survfit object (Kaplan-Meier
model)

\item \code{coxph}: Wraps \code{coxph(...)} in a survfit object (Kaplan-Meier
model)

\item \code{survfit}: Graphical output for survfit objects (Kaplan-Meier model)

\item \code{survfitcox}: Graphical output for survfit objects (Cox model)

\item \code{flexsurvreg}: Graphical output for flexsurvreg objects (various parametric models)
}}

\section{Generic graphical arguments}{
Unless specified, all graphics are created under \code{\link[ggpubr:ggpar]{ggpubr::ggpar()}} and have
as additional options \code{palette}, \code{main}, \code{submain}, \code{xlab}, \code{ylab},
\code{legend.title} and \code{ggtheme}. Most line graphics also allow to set the
options \code{size}, \code{linetype}, \code{alpha} and \code{color} to determine line styles, as
detailed on \code{\link[survminer:ggsurvplot]{survminer::ggsurvplot()}}.
\subsection{fit}{

Line graphic, with a further subset of the options present in
\code{\link[survminer:ggsurvplot]{survminer::ggsurvplot()}}: \code{censor}, \code{censor.shape}, \code{censor.size},
\code{conf.int}, \code{conf.int.style}.
}

\subsection{parametric}{

Line graphic, with a further subset of the options present in
\code{\link[survminer:ggflexsurvplot]{survminer::ggflexsurvplot()}}: \code{conf.int.km}.
}

\subsection{forest}{

Non-standard graphic(s), using all options within \code{\link[survminer:ggforest]{survminer::ggforest()}}:
\code{main}, \code{cpositions}, \code{fontsize}, \code{refLabel}, \code{noDigits}.
}

\subsection{residuals}{

Line graphic(s), with a further subset of options present in
\code{\link[survminer:ggcoxzph]{survminer::ggcoxzph()}}: \code{resid}, \code{se}, \code{df}, \code{nsmo}, \code{var}, \code{caption}; and
point style customization options as \code{point.col}, \code{point.size},
\code{point.shape}, and \code{point.alpha}.
}

\subsection{hazard}{

Line graphics, using the generic graphical arguments.
}
}

\examples{
# non-models are cohersed into a survfit object with default arguments
vsd(coxph(Surv(time, status) ~ sex + strata(rx) + adhere, data = colon), 
    .include = c("haz"))

# parametric models are also supported with flexsurv
vsd(flexsurv::flexsurvreg(Surv(rectime, censrec) ~ group, data = flexsurv::bc, dist = 'gengamma'),
    .include = c("par"))

}
