% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequalityMeasure.R
\name{AF}
\alias{AF}
\title{Allison and Foster index}
\usage{
AF(X, W = rep(1, length(X)), norm = TRUE)
}
\arguments{
\item{X}{is a data vector (numeric or ordered factor)}

\item{W}{is a vector of weights}

\item{norm}{(logical). If TRUE (default) then index is divided by a maximum possible value which is a difference between maximum and minimum of X}
}
\value{
The value of Allison and Foster coefficient.
}
\description{
Computes Allison and Foster inequality measure of a given variable taking into account weights.
}
\details{
Let \eqn{c=(c_{1},...,c_{n})} be the vector of categories in increasing order, \eqn{m} be the median category and \eqn{p_i} be a share of \eqn{i}-th category. The following index was proposed by Allison and Foster (2004):
\deqn{AF =  \frac{\sum_{i=m}^n c_{i} p_{i} }{\sum_{i=m}^n p_{i}} - \frac{\sum_{i=1}^{m-1} c_{i} p_{i}}{\sum_{i=1}^{m-1} p_{i}}}
Note that above formula is valid only for numerical values. Thus, in order to compute AF for ordered factor, X is converted to numerical variable.
}
\examples{
# Compare weighted and unweighted result
X=1:10
W=1:10
AF(X)
AF(X,W)

data(Well_being)
# Allison and Foster index for health assessment with sample weights
X=Well_being$V11
W=Well_being$Weight
AF(X,W)


}
\references{
Allison R. A., Foster J E.: (2004) Measuring health inequality using qualitative data, Journal of Health Economics
}
