% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\docType{data}
\name{wacolors}
\alias{wacolors}
\title{Washington State Color Palettes}
\format{
A list of character vectors containing the color palettes. Discrete
palette vectors contain names for each color.
}
\usage{
wacolors
}
\description{
A collection of colorblind-friendly color palettes for various settings in
the state of Washington. Colors were extracted from a set of photographs, and
then combined to form a set of continuous and discrete palettes.  Continuous
palettes were designed to be perceptually uniform, while discrete palettes
were chosen to maximize contrast at several different levels of overall
brightness and saturation. Each palette has been evaluated to ensure colors
are distinguishable by colorblind people.
}
\details{
Discrete palettes contain at most seven colors.  Don't create graphics that
use more than seven discrete colors.  You can color a map with four.
Anything more risks confusion.  Consider differentiating through faceting or
labels, instead.

Available palettes (use \code{\link[=wa_pal]{wa_pal()}} to visualize):
\itemize{
\item \code{rainier}
\item \code{washington_pass}
\item \code{palouse}
\item \code{forest}
\item \code{larch}
\item \code{coast}
\item \code{uw}
\item \code{fort_worden}
\item \code{skagit}
\item \code{flag}
\item \code{sound_sunset}
\item \code{ferries}
\item \code{forest_fire}
\item \code{sea}
\item \code{sea_star}
\item \code{volcano}
\item \code{baker}
\item \code{diablo}
\item \code{mountains}
\item \code{gorge}
\item \code{foothills}
\item \code{olympic}
\item \code{vantage}
}
}
\examples{
wacolors$rainier
wacolors$palouse[1:4]

}
\keyword{datasets}
