% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lspec_1.6.R
\name{lspec}
\alias{lspec}
\title{Create long spectrograms of whole sound files}
\usage{
lspec(X = NULL, flim = c(0,22), sxrow = 5, rows = 10, collev = seq(-40, 0, 1),
ovlp = 50, wl = 512, gr = FALSE, pal = reverse.gray.colors.2,
cex = 1, it = "jpeg", flist = NULL)
}
\arguments{
\item{X}{data frame with results from manualoc function (or any data frame with columns
as in a manualoc output data frame). If given, two red dotted lines are plotted at the
start and end of a selection and the selections are labeled with the selection number
(and selection comment, if available). Default is NULL.}

\item{flim}{A numeric vector of length two indicating the highest and lowest
frequency limits (kHz) of the spectrogram, as in
\code{\link[seewave]{spectro}}. Default is c(0,22).}

\item{sxrow}{A numeric vector of length one. Specifies seconds of spectrogram
per row. Default is 5.}

\item{rows}{A numeric vector of length one. Specifies number of rows per
image file. Default is 10.}

\item{collev}{A numeric vector of three. Specifies levels to partition the
amplitude range of the spectrogram (in dB). The more levels, the higher the
resolution of the spectrogram. Default is seq(-40, 0, 1).}

\item{ovlp}{Numeric vector of length one specifying % overlap between two
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 50. High values of ovlp
slow down the function but produce more accurate selection limits (when provided, see X).}

\item{wl}{A number specifying the window length of the spectrogram, default
is 512.}

\item{gr}{Logical argument to add grid to spectrogram. Default is FALSE.}

\item{pal}{Color palette function for spectrogram. Default is
reverse.gray.colors.2.}

\item{cex}{A numeric vector of length one giving the amount by which text
(including sound file and page number) should be magnified. Default is 1.}

\item{it}{A character vector of length one giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}

\item{flist}{character vector or factor indicating the subset of files that will be analyzed. Ignored
if X is provided.}
}
\value{
Spectrograms per individual call marked with dominant and fundamental
  frequencies.
}
\description{
\code{lspec} produce spectrograms of whole sound files split into multiple
  rows.
}
\details{
The function creates spectrograms for complete sound files, printing
  the name of the sound files and the "page" number (p1-p2...) at the upper
  right corner of the image files. If results from the manualoc function are
  supplied (or a equivalent data frame), the function delimits and labels the selections.
  This function aims to facilitate visual classification of vocalization units and the
  analysis of animal vocal sequences.
}
\examples{
\dontrun{
data(list = c("Arre.aura", "Phae.cuvi"))
data(manualoc.df)
writeWave(Arre.aura,"Arre.aura.wav") #save sound files
writeWave(Phae.cuvi,"Phae.cuvi.wav")
lspec(sxrow = 2, rows = 8, pal = reverse.heat.colors)
lspec(sxrow = 2, rows = 8, X = manualoc.df, pal = reverse.heat.colors) #including selections
}
}

