% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/snrspecs_1.4.R
\name{snrspecs}
\alias{snrspecs}
\title{Spectrograms with noise margins}
\usage{
snrspecs(X, wl = 512, flim = c(0, 22), wn = "hanning", pal =
  reverse.gray.colors.2, ovlp = 70, inner.mar = c(5, 4, 4, 2) + 0.1, outer.mar =
  c(0, 0, 0, 0), picsize = 1, res = 100, cexlab = 1, title = TRUE, trel =
  FALSE, propwidth = FALSE, xl=1, osci = FALSE, gr = FALSE, sc = FALSE, mar =
  0.2, snrmar = 0.1, it = "jpeg")
}
\arguments{
\item{X}{Data frame output from manualoc().}

\item{wl}{A number specifying the spectrogram window length, default is 512.}

\item{flim}{A numeric vector of length two for the frequency limit in kHz of
the spectrogram, as in \code{\link[seewave]{spectro}}. Default is c(0, 22).}

\item{wn}{Character vector of length one specifying window name. Default is
"hanning", as in \code{\link[seewave]{spectro}}.}

\item{pal}{Color palette function for spectrogram. Default is
reverse.gray.colors.2.}

\item{ovlp}{Numeric vector of length one specifying % overlap between two
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 70.}

\item{inner.mar}{Numeric vector with 4 elements, default is c(5,4,4,2)+0.1.
Specifies number of lines in inner plot margins where axis labels fall,
with form c(bottom, left, top, right). See \code{\link[graphics]{par}}.}

\item{outer.mar}{Numeric vector with 4 elements, default is c(0,0,0,0).
Specifies number of lines in outer plot margins beyond axis labels, with
form c(bottom, left, top, right). See \code{\link[graphics]{par}}.}

\item{picsize}{Numeric argument of length one, controls relative size of
spectrogram. Default is 1.}

\item{res}{Numeric argument of length one, controls resolution of image image.
Default is 100 (faster) although 300 - 400 is recommended for publication/
presentation quality.}

\item{cexlab}{Numeric vector of length one, specifies relative size of axis
labels. See \code{\link[seewave]{spectro}}.}

\item{title}{Logical argument to add a title to individual spectrograms.
Default is TRUE.}

\item{trel}{Logical argument to add a time axis scale relative to the wave.
Default is FALSE.}

\item{propwidth}{Logical argument to scale the width of spectrogram
proportionally to duration of the selected call. Default is FALSE.}

\item{xl}{Numeric vector of length one, a constant by which to scale
spectrogram width if propwidth = TRUE. Default is 1.}

\item{osci}{Logical argument to add an oscillogram underneath spectrogram, as
in \code{\link[seewave]{spectro}}. Default is FALSE.}

\item{gr}{Logical argument to add grid to spectrogram. Default is FALSE.}

\item{sc}{Logical argument to add amplitude scale to spectrogram, default is
FALSE.}

\item{mar}{Numeric vector of length one. Specifies the margins to subtract
from/add to start and end points of manualoc() selection, respectively,
delineating spectrogram limits. Default is 0.2.}

\item{snrmar}{Numeric vector of length one. Specifies the margins to subtract
from/add to start and end points of manualoc() selection, respectively,
where noise will be measured. Default is 0.1.}

\item{it}{A character vector of length one giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}
}
\value{
Spectrograms per individual call marked with margins and arrows where
  noise will be measured.
}
\description{
\code{snrspecs} create spectrograms to visualize margins over which noise
will be measured by sig2noise().
}
\details{
This function can be used to test different margins to facilitate
  accurate SNR measurements when using \code{\link{sig2noise}} down the line.
  Setting margins for individual calls that have been previously clipped from
  larger files may take some optimization, as will margins for calls within a
  larger file that are irregularly separated. Setting inner.mar to
  c(4,4.5,2,1) and outer.mar to c(4,2,2,1) works well when picsize = 2 or 3.
  Title font size, inner.mar and outer.mar (from mar and oma) don't work well
  when osci or sc = TRUE, this may take some optimization by the user.
}
\examples{
\dontrun{
data(list = c("Arre.aura", "Phae.cuvi"))
data(manualoc.df)
writeWave(Arre.aura, "Arre.aura.wav") #save sound.files
writeWave(Phae.cuvi, "Phae.cuvi.wav")

# make Arre.aura and Phae.cuvi spectrograms
# snrmar needs to be smaller before moving on to sig2noise()

snrspecs(manualoc.df, flim = c(0, 14), inner.mar = c(4,4.5,2,1), outer.mar = c(4,2,2,1),
picsize = 2, res = 300, cexlab = 2, mar = 0.2, snrmar = 0.1, it = "jpeg")

# make only Arre.aura spectrograms
# snrmar now doesn't overlap neighboring calls

snrspecs(manualoc.df[grepl(c("Arre"), manualoc.df$sound.files), ], flim = c(3, 14),
inner.mar = c(4,4.5,2,1), outer.mar = c(4,2,2,1), picsize = 2, res = 300, cexlab = 2,
mar = 0.2, snrmar = 0.01)
}
}
\author{
Marcelo Araya-Salas http://marceloarayasalas.weebly.com/ and Grace Smith Vidaurre
}
\seealso{
\code{\link{trackfreqs}} for creating spectrograms to visualize
  frequency measurements by \code{specan}, \code{\link{specreator}} for
  creating spectrograms after using \code{manualoc}

Other spectrogram.creators: \code{\link{specreator}};
  \code{\link{trackfreqs}}
}

