% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffts.R
\name{ffts}
\alias{ffts}
\title{Extract the fundamental frequency values as a time series}
\usage{
ffts(X, wl = 512, length.out = 20, wn = "hanning", ovlp = 70, bp = c(0, 22),
  threshold = 15, img = TRUE, parallel = 1, path = NULL, img.suffix = "ffts", pb = TRUE, 
  clip.edges = FALSE, leglab = "ffts", ff.method = "seewave", ...)
}
\arguments{
\item{X}{object of class 'selection_table', 'extended_selection_table' or data 
frame containing columns for sound file name (sound.files), 
selection number (selec), and start and end time of signal (start and end).
The ouptut of \code{\link{manualoc}} or \code{\link{autodetec}} can be used as the input data frame.}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is 512.}

\item{length.out}{A numeric vector of length 1 giving the number of measurements of fundamental 
frequency desired (the length of the time series).}

\item{wn}{Character vector of length 1 specifying window name. Default is 
"hanning". See function \code{\link[seewave]{ftwindow}} for more options.}

\item{ovlp}{Numeric vector of length 1 specifying \% of overlap between two 
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 70.}

\item{bp}{A numeric vector of length 2 for the lower and upper limits of a 
frequency bandpass filter (in kHz). Default is c(0, 22).}

\item{threshold}{amplitude threshold (\%) for fundamental frequency detection. Default is 15.}

\item{img}{Logical argument. If \code{FALSE}, image files are not produced. Default is \code{TRUE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{img.suffix}{A character vector of length 1 with a suffix (label) to add at the end of the names of 
image files.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{clip.edges}{Logical argument to control whether edges (start or end of signal) in
which amplitude values above the threshold were not detected will be removed. If 
\code{TRUE} this edges will be excluded and signal contour will be calculated on the
remainging values. Default is \code{FALSE}. 
#' @param leglab A character vector of length 1 or 2 containing the label(s) of the frequency contour legend 
in the output image.}

\item{leglab}{A character vector of length 1 or 2 containing the label(s) of the frequency contour legend 
in the output image.}

\item{ff.method}{Character. Selects the method used to calculate the fundamental
frequency. Either 'tuneR' (using \code{\link[tuneR]{FF}}) or 'seewave' (using 
\code{\link[seewave]{fund}}). Default is 'seewave'. 'tuneR' performs
faster (and seems to be more accurate) than 'seewave'.}

\item{...}{Additional arguments to be passed to \code{\link{trackfreqs}}. for customizing
graphical output.}
}
\value{
A data frame with the fundamental frequency values measured across the signals. If img is 
\code{TRUE} it also produces image files with the spectrograms of the signals listed in the 
input data frame showing the location of the fundamental frequencies 
(see \code{\link{trackfreqs}} description for more details).
}
\description{
\code{ffts} extracts the fundamental frequency values as a time series
of signals selected by \code{\link{manualoc}} or \code{\link{autodetec}}.
}
\details{
This function extracts the fundamental frequency values as a time series. 
The function uses the \code{\link[stats]{approx}} function to interpolate values between fundamental frequency #' measures. If there are no frequencies above the amplitude theshold at the begining or end 
 of the signals then NAs will be generated. On the other hand, if there are no frequencies 
 above the amplitude theshold in between signal segments in which amplitude was 
 detected then the values of this adjacent segments will be interpolated 
 to fill out the missing values (e.g. no NAs in between detected amplitude segments).
}
\examples{
{
#load data
data(list = c("Phae.long1", "Phae.long2","lbh_selec_table"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav")) #save sound files 
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav")) #save sound files 

# run function 
ffts(lbh_selec_table, length.out = 50, flim = c(1, 12), bp = c(2, 9), wl = 300, path = tempdir())
}
}
\seealso{
\code{\link{sig2noise}}, \code{\link{trackfreqs}}, \code{\link{dfts}}, \code{\link{ffDTW}}, \code{\link{dfDTW}}

Other spectrogram creators: \code{\link{color.spectro}},
  \code{\link{dfDTW}}, \code{\link{dfts}},
  \code{\link{ffDTW}}, \code{\link{multi_DTW}},
  \code{\link{phylo_spectro}}, \code{\link{snrspecs}},
  \code{\link{sp.en.ts}}, \code{\link{specreator}},
  \code{\link{trackfreqs}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
\concept{spectrogram creators}
