% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_sound_files.R
\name{info_sound_files}
\alias{info_sound_files}
\title{Get sound file parameter information}
\usage{
info_sound_files(
  path = NULL,
  files = NULL,
  parallel = 1,
  pb = TRUE,
  skip.error = FALSE,
  file.format = "\\\\.wav$|\\\\.wac$|\\\\.mp3$|\\\\.flac$"
)
}
\arguments{
\item{path}{Character string containing the directory path where the sound files are located.
If \code{NULL} (default) then the current working directory is used.}

\item{files}{character vector indicating the set of files that will be consolidated. File names should not include the full file path. Optional.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar and messages. Default is \code{TRUE}.}

\item{skip.error}{Logical to control if errors are omitted. If so, files that could not be read will be excluded and their name printed in the console. Default is \code{FALSE}, which will return an error if some files are problematic.}

\item{file.format}{Character string with the format of sound files. By default all sound file formats supported by warbleR are included ("\\\.wav$|\\\.wac$|\\\.mp3$|\\\.flac$"). Note that several formats can be included using regular expression syntax as in \code{\link[base]{grep}}. For instance \code{"\\\.wav$|\\\.mp3$"} will only include .wav and .mp3 files.}
}
\value{
A data frame with descriptive information about the sound files in the working directory (or 'path'). See "details".
}
\description{
\code{info_sound_files} summariz sound file information
}
\details{
This function is a wrapper for \code{\link{selection_table}} that returns a data frame with the following descriptive parameters for each sound file in the working directory (or 'path'):
\itemize{
   \item \code{duration}: duration of selection in seconds
   \item \code{sample.rate}: sampling rate in kHz
   \item \code{channels}: number of channels
   \item \code{bits}: bit depth
   \item \code{wav.size}: sound file size in MB
   \item \code{samples}: number of samples in the sound file
   }
}
\examples{
{
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "lbh_selec_table"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))
writeWave(Phae.long4, file.path(tempdir(), "Phae.long4.wav"))

#get info
info_sound_files(path = tempdir())
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{fix_wavs}}, \code{\link{selection_table}} & \code{\link{check_sels}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
