% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig2noise.R
\name{sig2noise}
\alias{sig2noise}
\title{Measure signal-to-noise ratio}
\source{
\url{https://en.wikipedia.org/wiki/Signal-to-noise_ratio}
}
\usage{
sig2noise(X, mar, parallel = 1, path = NULL, pb = TRUE)
}
\arguments{
\item{X}{Data frame with results from \code{\link{manualoc}} or any data frame with columns
for sound file name (sound.files), selection number (selec), and start and end time of signal
(start and end).}

\item{mar}{numeric vector of length 1. Specifies the margins adjacent to
the start and end points of selection over which to measure noise.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).
Not available in Windows OS.}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}. Note that progress bar is only used
when parallel = 1.}
}
\value{
Data frame similar to \code{\link{autodetec}} output, but also includes a new variable 
with the signal-to-noise values.
}
\description{
\code{sig2noise} measures signal-to-noise ratio across multiple files.
}
\details{
Signal-to-noise ratio (SNR) is a measure of the level of a desired signal compared to 
 background noise. The function divides the mean amplitude of the signal by 
  the mean amplitude of the background noise adjacent to the signal. 
  A general margin to apply before and after the acoustic signal must 
  be specified. Setting margins for individual signals that have been 
  previously clipped from larger files may take some optimization, as 
  for calls within a larger file that are irregularly separated. When
  margins overlap with another acoustic signal nearby, the signal-to-noise 
  ratio (SNR) will be inaccurate. Any SNR less than or equal to one suggests 
  background noise is equal to or overpowering the acoustic signal.
  \code{\link{snrspecs}} can be used to troubleshoot different noise margins.
}
\examples{
\dontrun{
# First set temporary folder
setwd(tempdir())

data(list = c("Phae.long1","manualoc.df"))
writeWave(Phae.long1, "Phae.long1.wav") #save sound files 

# specifying the correct margin is important
# use snrspecs to troubleshoot margins for sound files
sig2noise(manualoc.df[grep("Phae.long1", manualoc.df$sound.files), ], mar = 0.2)

# this smaller margin doesn't overlap neighboring signals
sig2noise(manualoc.df[grep("Phae.long1", manualoc.df$sound.files), ], mar = 0.1)
}

}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu}) and Grace Smith Vidaurre
}

