% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHearings.R
\name{getHearings}
\alias{getHearings}
\title{Get hearings regarding a bill}
\usage{
getHearings(biennium, billNumber, paired = TRUE, type = c("df", "list", "xml"))
}
\arguments{
\item{biennium}{Character vector representing the biennium(s) to be
searched. Each argument should take the form "XXXX-YY"}

\item{billNumber}{Character or numeric vector containing the bill number(s)
to be retrieved.}

\item{paired}{If TRUE, will assume that equal length vectors represent
paired data. Set to FALSE to generate an NxN grid of input
arguments. Applies to equal length vector inputs only.}

\item{type}{One of "df", "list", or "xml". Specifies the format for
the output.}
}
\value{
\code{getHearings} returns an object of type equal to the
\code{type} argument (defaults to dataframe)
}
\description{
Get a list of dates, locations, and descriptions of all
committee hearings on a particular bill
}
\section{Note}{
 Due to the nature of the resulting XML document,
the function trims data from excessively nested lists when
\code{type = "df"}. In order to access the full information, use
\code{type = "list"} instead.
}

\examples{
## get hearings for all senate bills in 2011
bills <- getLegislationByYear("2011")
billsSenate <- subset(bills, OriginalAgency == "Senate")

\dontrun{getHearings(billsSenate$Biennium, billsSenate$BillNumber, paired = TRUE, type = "df")}

}
