% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/watch.R
\name{watcher}
\alias{watcher}
\title{Watch a Filesystem Location}
\usage{
watcher(path = getwd(), callback = NULL, latency = 1)
}
\arguments{
\item{path}{Character path to a file, or directory to watch recursively.
Defaults to the current working directory.}

\item{callback}{A function or formula (see \link[rlang:as_function]{rlang::as_function}), which takes
at least one argument. It will be called back with a character vector
comprising the paths of all files that have changed. The default, \code{NULL},
causes the paths that have changed to be written to \code{stdout} instead.}

\item{latency}{Numeric latency in seconds for events to be reported or
callbacks triggered. The default is 1s.}
}
\value{
A 'Watcher' R6 class object. Start and stop background monitoring
using the \verb{$start()} and \verb{$stop()} methods - these return a logical value
whether or not they have succeeded.
}
\description{
Create a 'Watcher' on a filesystem location to monitor for changes in the
background.
}
\details{
Uses the optimal event-driven API for each platform: 'ReadDirectoryChangesW'
on Windows, 'FSEvents' on MacOS, 'inotify' on Linux, 'kqueue' on BSD, and
'File Events Notification' on Solaris/Illumos.

Note: the \code{latency} setting does not mean that changes are polled for at this
interval, these still rely on the optimal platform-specific monitor. The
implementation of 'latency' is also platform-dependent.

Events are 'bubbled' such that a single change that triggers multiple event
flags will cause the callback to be called only once.

It is possible to set a watch on a path that does not currently exist, and it
will be monitored once created.
}
\examples{
w <- watcher(tempdir())
w$start()
w
w$stop()
w

Sys.sleep(1)

}
