% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdi_get.R
\name{wdi_get}
\alias{wdi_get}
\title{Download World Bank indicator data for specific entities and time periods}
\usage{
wdi_get(
  entities,
  indicators,
  start_year = NULL,
  end_year = NULL,
  most_recent_only = FALSE,
  frequency = "annual",
  language = "en",
  per_page = 10000L,
  progress = TRUE,
  source = NULL,
  format = "long"
)
}
\arguments{
\item{entities}{A character vector of ISO 2 or ISO 3-country codes, or
\code{"all"} to retrieve data for all entities.}

\item{indicators}{A character vector specifying one or more World Bank
indicators to download (e.g., c("NY.GDP.PCAP.KD", "SP.POP.TOTL")).}

\item{start_year}{Optional integer. The starting date for the data as a year.}

\item{end_year}{Optional integer. The ending date for the data as a year.}

\item{most_recent_only}{A logical value indicating whether to download only
the most recent value. In case of \code{TRUE}, it overrides \code{start_year} and
\code{end_year}. Defaults to \code{FALSE}.}

\item{frequency}{A character string specifying the frequency of the data
("annual", "quarter", "month"). Defaults to "annual".}

\item{language}{A character string specifying the language for the request,
see \link{wdi_get_languages}. Defaults to \code{"en"}.}

\item{per_page}{An integer specifying the number of results per page for the
API. Defaults to 10,000.}

\item{progress}{A logical value indicating whether to show progress messages
during the data download and parsing. Defaults to \code{TRUE}.}

\item{source}{An integer value specifying the data source, see
\link{wdi_get_sources}.}

\item{format}{A character value specifying whether the data is returned in
\code{"long"} or \code{"wide"} format. Defaults to \code{"long"}.}
}
\value{
A tibble with the following columns:
\describe{
\item{entity_id}{The ISO 3-country code of the country or aggregate for
which the data was retrieved.}
\item{indicator_id}{The ID of the indicator (e.g., "NY.GDP.PCAP.KD").}
\item{year}{The year of the indicator data as an integer.}
\item{quarter}{Optional. The quarter of the indicator data as integer.}
\item{month}{Optional. The month of the indicator data as integer.}
\item{value}{The value of the indicator for the given country and date.}
}
}
\description{
This function retrieves indicator data from the World Bank API for a
specified set of entities and indicators. The user can specify one or more
indicators, a date range, and other options to tailor the request. The data
is processed and returned in a tidy format, including country, indicator,
date, and value fields.
}
\details{
This function constructs a request URL for the World Bank API,
retrieves the relevant data for the given entities and indicators, and
processes the response into a tidy format. The user can optionally specify a
date range, and the function will handle requests for multiple pages if
necessary. If the \code{progress} parameter is \code{TRUE}, messages will be displayed
during the request and parsing process.

The function supports downloading multiple indicators by sending individual
API requests for each indicator and then combining the results into a single
tidy data frame.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Download single indicator for multiple entities
wdi_get(c("USA", "CAN", "GBR"), "NY.GDP.PCAP.KD")

# Download single indicator for a specific time frame
wdi_get(c("USA", "CAN", "GBR"), "DPANUSSPB",
        start_year = 2012, end_year = 2013)

# Download single indicator for monthly frequency
wdi_get("AUT", "DPANUSSPB",
        start_year = 2012, end_year = 2015, frequency = "month")

# Download single indicator for quarterly frequency
wdi_get("NGA", "DT.DOD.DECT.CD.TL.US",
        start_year = 2012, end_year = 2015, frequency = "quarter")

# Download single indicator for all entities and disable progress bar
wdi_get("all", "NY.GDP.PCAP.KD", progress = FALSE)

# Download multiple indicators for multiple entities
wdi_get(c("USA", "CAN", "GBR"), c("NY.GDP.PCAP.KD", "SP.POP.TOTL"))

# Download indicators for different sources
wdi_get("DEU", "SG.LAW.INDX", source = 2)
wdi_get("DEU", "SG.LAW.INDX", source = 14)

# Download indicators in wide format
wdi_get(c("USA", "CAN", "GBR"), c("NY.GDP.PCAP.KD"),
        format = "wide")
wdi_get(c("USA", "CAN", "GBR"), c("NY.GDP.PCAP.KD", "SP.POP.TOTL"),
        format = "wide")

# Download most recent value only
wdi_get("USA", "SP.POP.TOTL", most_recent_only = TRUE)
}
\dontshow{\}) # examplesIf}
}
