% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dprewire_directed_cpp}
\alias{dprewire_directed_cpp}
\title{Degree preserving rewiring process for directed networks.}
\usage{
dprewire_directed_cpp(
  iteration,
  nattempts,
  tnode,
  sout,
  sin,
  tout,
  tin,
  index_s,
  index_t,
  eta,
  rewire_history
)
}
\arguments{
\item{iteration}{Integer, number of iterations for rewiring attempts.}

\item{nattempts}{Integer, number of rewiring attempts per iteration.}

\item{tnode}{Vector, target node sequence - 1.}

\item{sout}{Vector, source nodes' out-degree.}

\item{sin}{Vector, source nodes' in-degree.}

\item{tout}{Vector, target nodes' out-degree.}

\item{tin}{Vector, target nodes' in-degree.}

\item{index_s}{Index of source nodes' out- and in-degree. 
\code{index_s}/\code{index_t} bridges the indices of source/target nodes and the 
target structure eta.}

\item{index_t}{Index of target nodes' out- and in-degree.}

\item{eta}{Matrix, target structure eta generated by
\code{wdnet::get_eta_directed()}.}

\item{rewire_history}{Logical, whether the rewiring history should be returned.}
}
\value{
Returns target node sequence, four directed assortativity coefficients after each iteration, and rewire history.
}
\description{
Degree preserving rewiring process for directed networks.
}
\keyword{internal}
