% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cls_wdnet.R
\name{print.wdnet}
\alias{print.wdnet}
\alias{summary.wdnet}
\title{Prints the input network}
\usage{
\method{print}{wdnet}(x, node.attrs = TRUE, edge.attrs = TRUE, max.lines = 5, ...)

\method{summary}{wdnet}(object, ...)
}
\arguments{
\item{x}{A \code{wdnet} object.}

\item{node.attrs}{Logical, whether to print node attributes, if available.}

\item{edge.attrs}{Logical, whether to print edge attributes, if available.}

\item{max.lines}{Integer, the maximum number of lines of edgelist and node
attributes to print. The rest of the output will be truncated.}

\item{...}{Additional arguments.}

\item{object}{The graph of which the summary will be printed.}
}
\description{
These functions print a network to the terminal.
}
\details{
\code{summary.wdnet} prints the number of nodes and edges, preference
functions, and whether the network is directed, weighted. \code{print.wdnet}
prints the same information, and also lists some edges and node attributes,
if available. Edge scenarios are 0: from initial network; 1: \code{alpha}; 2:
\code{beta}; 3: \code{gamma}; 4: \code{xi}; 5; \code{rho}; 6: reciprocal.
}
