% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_repair_geometry.R
\name{st_repair_geometry}
\alias{st_repair_geometry}
\title{Repair geometry}
\usage{
st_repair_geometry(x, geometry_precision = 1500)
}
\arguments{
\item{x}{\code{\link[sf:sf]{sf::sf()}} object.}

\item{geometry_precision}{\code{numeric} level of precision for processing
the spatial data (used with \code{\link[sf:st_precision]{sf::st_set_precision()}}). The
default argument is 1500 (higher values indicate higher precision).
This level of precision is generally suitable for analyses at the
national-scale. For analyses at finer-scale resolutions, please
consider using a greater value (e.g. 10000).}
}
\description{
Repair the geometry of a \code{\link[sf:sf]{sf::st_sf()}} object.
}
\details{
This function works by first using the \code{\link[sf:valid]{sf::st_make_valid()}} function
to attempt to fix geometry issues. Since the \code{\link[sf:valid]{sf::st_make_valid()}} function
sometimes produce incorrect geometries in rare cases
(e.g. when fixing invalid geometries that cross the dateline),
this function then uses the \code{st_prepair()} function from the \pkg{prepr}
package to fix those geometries instead
(see \url{https://github.com/dickoa/prepr} for details).
}
\section{Installation}{

This function uses the \pkg{prepr} package to help repair geometries
in certain cases. Because the \pkg{prepr} package is not available on
the Comprehensive R Archive Network (CRAN), it must be installed from
its online code repository. To achieve this, please
use the following code:\preformatted{if (!require(remotes)) install.packages("remotes")
remotes::install_github("dickoa/prepr")
}

Note that the \pkg{prepr} package has system dependencies that need to be
installed before the package itself can be installed
(see package README file for platform-specific instructions).
}

\examples{
# create sf object
p1 <- st_sf(
  id = 1,
  geometry = st_as_sfc("POLYGON((0 0, 0 10, 10 0, 10 10, 0 0))", crs = 3857)
)

# repair geometry
p2 <- st_repair_geometry(p1)

# print object
print(p2)
}
