% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thermalTime.R
\name{thermalTimeHourly}
\alias{thermalTimeHourly}
\title{Calculate thermal time using the hourly temperature (non daily temperature)}
\usage{
thermalTimeHourly(timestamp, temperature, x_temp, y_temp)
}
\arguments{
\item{timestamp}{The timestamp of weather records}

\item{temperature}{The temperature}

\item{x_temp}{The cardinal temperatures}

\item{y_temp}{The effective thermal time}
}
\value{
A data frame with daily thermal time
}
\description{
Calculate thermal time using the hourly temperature (non daily temperature)
}
\examples{
met_file <- system.file("extdata/WeatherHourly.csv", package = "weaana")
hourly <- read.csv(met_file, as.is = TRUE) 

hourly$timestamp <- as.POSIXct(hourly$timestamp, format = "\%Y-\%m-\%dT\%H:\%M:\%SZ")
x_temp <- c(0, 20, 35)
y_temp <- c(0, 20, 0)
thermalTimeHourly(hourly$timestamp, hourly$temperature, x_temp, y_temp)
}
