% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heat_index.R
\name{heat.index.algorithm}
\alias{heat.index.algorithm}
\title{Algorithm for heat.index function.}
\usage{
heat.index.algorithm(t = NA, rh = NA)
}
\arguments{
\item{t}{Numeric scalar of air temperature, in Fahrenheit.}

\item{rh}{Numeric scalar of relative humidity, in \%.}
}
\value{
A numeric scalar of heat index, in Fahrenheit.
}
\description{
\code{heat.index.algorithm} converts a numeric scalar of temperature
   (in Fahrenheit) and a numeric scalar of relative humidity (in \%)
   to heat index (in Fahrenheit). This function is not meant to be used
   outside of the \code{\link{heat.index}} function.
}
\details{
If an impossible value of relative humidity is given
   (below 0\% or above 100\%), heat index is returned as \code{NA}.
}
\note{
Equations are from the source code for the US National Weather
    Service's
    \href{http://www.wpc.ncep.noaa.gov/html/heatindex.shtml}{online heat index calculator}.
}
\author{
Brooke Anderson \email{brooke.anderson@colostate.edu},
Roger Peng \email{rdpeng@gmail.com}
}
\references{
Anderson GB, Bell ML, Peng RD. 2013. Methods to calculate the heat index
   as an exposure Metric in environmental health research.
   Environmental Health Perspectives 121(10):1111-1119.

National Weather Service Hydrometeorological Prediction
   Center Web Team. Heat Index Calculator. 30 Jan 2015.
   \url{http://www.wpc.ncep.noaa.gov/html/heatindex.shtml}.
   Accessed 18 Dec 2015.

Rothfusz L. 1990. The heat index (or, more than you ever wanted to know
   about heat index) (Technical Attachment SR 90-23). Fort Worth:
   Scientific Services Division, National Weather Service.

R. Steadman, 1979. The assessment of sultriness. Part I: A
   temperature-humidity index based on human physiology and clothing
   science. Journal of Applied Meteorology, 18(7):861--873.
}
\seealso{
\code{\link{heat.index}}
}

