% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pubchem.R
\name{cid_compinfo}
\alias{cid_compinfo}
\title{Convert CID to SMILES}
\usage{
cid_compinfo(cid, first = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{cid}{character; Pubchem ID (CID).}

\item{first}{logical; return only first list items?
That is: a list with entries of lenght 1 (for easy conversion in a data.frame)}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
a list with entries: CID (Pubchem ID), InChIKey, InChI,
synonyms, IUPACName, Canonical SMILES, Isomeric SMILES, MolecularFormula,
MolecularWeight, TotalFormalCharge, XlogP, HydrogenBondDonorCount,
HydrogenBondAcceptorCount, Complexity,  HeavyAtomCount, AtomChiralCount,
AtomChiralDefCount, AtomChiralUndefCount, BondChiralCount, BondChiralDefCount,
BondChiralUndefCount, IsotopeAtomCount, CovalentUnitCount, TautomerCount
}
\description{
Convert CompoundID (CID) to SMILES, see \url{https://pubchem.ncbi.nlm.nih.gov/}
}
\examples{
\donttest{
# might fail if API is not available
cid <- get_cid('Triclosan')
cid_compinfo(cid[1])
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
\seealso{
\code{\link{get_cid}} to retrieve Pubchem IDs.
}

