% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cts.R
\name{cts_compinfo}
\alias{cts_compinfo}
\title{Get record details from Chemical Translation Service (CTS)}
\usage{
cts_compinfo(inchikey, verbose = TRUE, ...)
}
\arguments{
\item{inchikey}{character; InChIkey.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
a list of 7. inchikey, inchicode, molweight, exactmass, formula, synonyms and externalIds
}
\description{
Get record details from CTS, see \url{http://cts.fiehnlab.ucdavis.edu}
}
\examples{
\donttest{
# might fail if API is not available
out <- cts_compinfo("XEFQLINVKFYRCS-UHFFFAOYSA-N")
# = Triclosan
str(out)
out[1:5]

### multiple inputs
comp <- c('Triclosan', 'Aspirin')
inchkeys <- sapply(comp, function(x) cir_query(x, 'stdinchikey', first = TRUE))
# ne to strip '#InChIKey='
inchkeys <- gsub('InChIKey=', '', inchkeys)
ll <- lapply(inchkeys, function(x) cts_compinfo(x)[1:5])
do.call(rbind, ll)
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}

