% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemspider.R
\name{cs_extcompinfo}
\alias{cs_extcompinfo}
\title{Get extended record details by ChemSpider ID}
\usage{
cs_extcompinfo(csid, token, verbose = TRUE, ...)
}
\arguments{
\item{csid}{character,  ChemSpider ID.}

\item{token}{character; security token.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
a list with entries: CSID (ChemSpider ID), MF (Molecular Formula),
SMILES string, InChI, InChIKey, Average Mass, Molecular weight, MonoisotopicMass,
NominalMass, ALogP, XLogP and the common Name.
}
\description{
Get extended info from Chemspider, see \url{http://www.chemspider.com/}
}
\note{
A security token is neeeded. Please register at RSC
\url{https://www.rsc.org/rsc-id/register}
for a security token.
}
\examples{
\dontrun{
# Fails because no TOKEN is included
token <- '<YOUR-SECURITY-TOKEN>'
# convert CAS to CSID
csid <- get_csid("Triclosan", token = token)
# get SMILES from CSID
cs_extcompinfo(csid, token)

###
# multiple inpits
csids <- sapply(c('Aspirin', 'Triclosan'), get_csid, token = token)
# fails:
# cs_extcompinfo(csids, token = token)
(ll <- lapply(csids, cs_extcompinfo, token = token))
# to matrix
do.call(rbind, ll)
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
\seealso{
\code{\link{get_csid}} to retrieve ChemSpider IDs,
\code{\link{csid_compinfo}} for extended compound information.
}

