% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth.R
\name{oauth2_login}
\alias{oauth2_login}
\title{Helper function to log in to a third party OAuth2.0 app without a
browser}
\usage{
oauth2_login(login_url)
}
\arguments{
\item{login_url}{The login URL of the third party app.}
}
\value{
A named list with
\itemize{
\item \code{login_response} The curl HTTP response object for the login
page.
\item \code{token_response} The curl HTTP response object for submitting
the login page.
}
}
\description{
It works with \code{\link[=oauth2_resource_app]{oauth2_resource_app()}}, and any third party app,
including the fake \code{\link[=oauth2_third_party_app]{oauth2_third_party_app()}}.
}
\details{
See \code{test-oauth.R} in webfakes for an example.
}
\seealso{
Other OAuth2.0 functions: 
\code{\link{oauth2_httr_login}()},
\code{\link{oauth2_resource_app}()},
\code{\link{oauth2_third_party_app}()}
}
\concept{OAuth2.0 functions}
