% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mw-json.R
\name{mw_json}
\alias{mw_json}
\title{Middleware to parse a JSON body}
\usage{
mw_json(type = "application/json", simplifyVector = FALSE, ...)
}
\arguments{
\item{type}{Content type to match before parsing. If it does not
match, then the request object is not modified.}

\item{simplifyVector}{Whether to simplify lists to vectors, passed to
\code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}}.}

\item{...}{Arguments to pass to \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}}, that performs
the JSON parsing.}
}
\value{
Handler function.
}
\description{
Adds the parsed object as the \code{json} element of the request object.
}
\examples{
app <- new_app()
app$use(mw_json())
app
}
\seealso{
Other middleware: 
\code{\link{mw_cookie_parser}()},
\code{\link{mw_etag}()},
\code{\link{mw_log}()},
\code{\link{mw_multipart}()},
\code{\link{mw_range_parser}()},
\code{\link{mw_raw}()},
\code{\link{mw_static}()},
\code{\link{mw_text}()},
\code{\link{mw_urlencoded}()}
}
\concept{middleware}
