% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmdshot.R
\name{rmdshot}
\alias{rmdshot}
\title{Take a snapshot of an R Markdown document}
\usage{
rmdshot(
  doc,
  file = "webshot.png",
  ...,
  delay = NULL,
  rmd_args = list(),
  port = getOption("shiny.port"),
  envvars = NULL
)
}
\arguments{
\item{doc}{The path to a Rmd document.}

\item{file}{A vector of names of output files. Should end with \code{.png},
\code{.pdf}, or \code{.jpeg}. If several screenshots have to be taken and
only one filename is provided, then the function appends the index number
of the screenshot to the file name.}

\item{...}{Other arguments to pass on to \code{\link{webshot}}.}

\item{delay}{Time to wait before taking screenshot, in seconds. Sometimes a
longer delay is needed for all assets to display properly. If NULL (the
default), then it will use 0.2 seconds for static Rmd documents, and 3
seconds for Rmd documents with runtime:shiny.}

\item{rmd_args}{A list of additional arguments to pass to either
\code{\link[rmarkdown]{render}} (for static Rmd documents) or
\code{\link[rmarkdown]{run}} (for Rmd documents with runtime:shiny).}

\item{port}{Port that Shiny will listen on.}

\item{envvars}{A named character vector or named list of environment
variables and values to set for the Shiny app's R process. These will be
unset after the process exits. This can be used to pass configuration
information to a Shiny app.}
}
\description{
This function can handle both static Rmd documents and Rmd documents with
\code{runtime: shiny}.
}
\examples{
if (interactive()) {
  # rmdshot("rmarkdown_file.Rmd", "snapshot.png")

  # R Markdown file
  input_file <- system.file("examples/knitr-minimal.Rmd", package = "knitr")
  rmdshot(input_file, "minimal_rmd.png")

  # Shiny R Markdown file
  input_file <- system.file("examples/shiny.Rmd", package = "webshot")
  rmdshot(input_file, "shiny_rmd.png", delay = 5)
}

}
