% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{add_session}
\alias{add_session}
\title{Add a session variable}
\usage{
add_session(wt, cutoff)
}
\arguments{
\item{wt}{webtrack data object.}

\item{cutoff}{numeric (seconds). If the difference between two consecutive
timestamps exceeds this value, a new browsing session is defined.}
}
\value{
webtrack data.table (ordered by panelist_id and timestamp)
with the same columns as wt and a new column called \code{session}.
}
\description{
\code{add_session()} groups visits into "sessions", defining a session to end
when the difference between two consecutive timestamps exceeds a \code{cutoff}.
}
\examples{
\dontrun{
data("testdt_tracking")
wt <- as.wt_dt(testdt_tracking)
# Setting cutoff to 30 minutes
wt <- add_session(wt, cutoff = 1800)
}
}
