% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{extract_host}
\alias{extract_host}
\title{Extract the host from URL}
\usage{
extract_host(wt, varname = "url")
}
\arguments{
\item{wt}{webtrack data object.}

\item{varname}{character. Name of the column from which to extract the host.
Defaults to \code{"url"}.}
}
\value{
webtrack data.frame with the same columns as wt
and a new column called \code{'host'} (or, if varname not equal to \code{'url'}, \code{'<varname>_host'})
}
\description{
\code{extract_host()} adds the host of a URL as a new column.
The host is defined as the part following the scheme (e.g., "https://") and
preceding the subdirectory (anything following the next "/"). Note that
for URL entries like \verb{chrome-extension://soomething} or \verb{http://192.168.0.1/something},
result will be set to \code{NA}.
}
\examples{
\dontrun{
data("testdt_tracking")
wt <- as.wt_dt(testdt_tracking)
# Extract host and drop rows without host
wt <- extract_host(wt)
# Extract host and keep rows without host
wt <- extract_host(wt)
}
}
