% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{sum_visits}
\alias{sum_visits}
\title{Summarize number of visits by person}
\usage{
sum_visits(wt, timeframe = NULL, visit_class = NULL)
}
\arguments{
\item{wt}{webtrack data object.}

\item{timeframe}{character. Indicates for what time frame to aggregate visits.
Possible values are \code{"date"}, \code{"week"}, \code{"month"}, \code{"year"}, \code{"wave"} or \code{NULL}.
If set to \code{"wave"}, \code{wt} must contain a column call \code{wave}. Defaults to \code{NULL},
in which case the output contains number of visits for the entire time.}

\item{visit_class}{character. Column that contains a classification of visits.
For each value in this column, the output will have a column indicating the
number of visits belonging to that value. Defaults to \code{NULL}.}
}
\value{
a data.frame with columns \code{panelist_id}, column indicating the time unit
(unless \code{timeframe} set to \code{NULL}), \code{n_visits} indicating the number of visits,
and a column for each value of \code{visit_class}, if specified.
}
\description{
\code{sum_visits()} summarizes the number of visits by person within a \code{timeframe},
and optionally by \code{visit_class} of visit.
}
\examples{
\dontrun{
data("testdt_tracking")
wt <- as.wt_dt(testdt_tracking)
# summarize for whole period
wt_summ <- sum_visits(wt)
# summarize by week
wt_summ <- sum_visits(wt, timeframe = "week")
# create a class variable to summarize by class
wt <- extract_domain(wt)
wt$google <- ifelse(wt$domain == "google.com", 1, 0)]
wt_summ <- sum_visits(wt, timeframe = "week", visit_class = "google")
}
}
