% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/espn_wnba_data.R
\name{espn_wnba_game_rosters}
\alias{espn_wnba_game_rosters}
\title{\strong{Get ESPN WNBA game rosters}}
\usage{
espn_wnba_game_rosters(game_id)
}
\arguments{
\item{game_id}{Game ID}
}
\value{
A game rosters data frame\tabular{ll}{
   col_name \tab types \cr
   athlete_id \tab integer \cr
   athlete_uid \tab character \cr
   athlete_guid \tab character \cr
   athlete_type \tab character \cr
   sdr \tab integer \cr
   first_name \tab character \cr
   last_name \tab character \cr
   full_name \tab character \cr
   athlete_display_name \tab character \cr
   short_name \tab character \cr
   weight \tab numeric \cr
   display_weight \tab character \cr
   height \tab numeric \cr
   display_height \tab character \cr
   age \tab integer \cr
   date_of_birth \tab character \cr
   slug \tab character \cr
   headshot_href \tab character \cr
   headshot_alt \tab character \cr
   jersey \tab character \cr
   position_id \tab integer \cr
   position_name \tab character \cr
   position_display_name \tab character \cr
   position_abbreviation \tab character \cr
   position_leaf \tab logical \cr
   linked \tab logical \cr
   years \tab integer \cr
   active \tab logical \cr
   status_id \tab integer \cr
   status_name \tab character \cr
   status_type \tab character \cr
   status_abbreviation \tab character \cr
   birth_place_city \tab character \cr
   birth_place_state \tab character \cr
   birth_place_country \tab character \cr
   starter \tab logical \cr
   valid \tab logical \cr
   did_not_play \tab logical \cr
   display_name \tab character \cr
   reason \tab character \cr
   ejected \tab logical \cr
   team_id \tab integer \cr
   team_guid \tab character \cr
   team_uid \tab character \cr
   team_sdr \tab integer \cr
   team_slug \tab character \cr
   team_location \tab character \cr
   team_name \tab character \cr
   team_abbreviation \tab character \cr
   team_display_name \tab character \cr
   team_short_display_name \tab character \cr
   team_color \tab character \cr
   team_alternate_color \tab character \cr
   team_is_active \tab logical \cr
   is_all_star \tab logical \cr
   logo_href \tab character \cr
   logo_dark_href \tab character \cr
   logos_href_2 \tab character \cr
   logos_href_3 \tab character \cr
   game_id \tab integer \cr
   order \tab integer \cr
   home_away \tab character \cr
   winner \tab logical \cr
   draft_display_text \tab character \cr
   draft_round \tab integer \cr
   draft_year \tab integer \cr
   draft_selection \tab integer \cr
   hand_type \tab character \cr
   hand_abbreviation \tab character \cr
   hand_display_value \tab character \cr
   citizenship \tab character \cr
}
}
\description{
\strong{Get ESPN WNBA game rosters}
}
\examples{
\donttest{
  try(espn_wnba_game_rosters(game_id = 401244185))
}
}
\seealso{
Other ESPN WNBA Functions: 
\code{\link{espn_wnba_game_all}()},
\code{\link{espn_wnba_pbp}()},
\code{\link{espn_wnba_player_box}()},
\code{\link{espn_wnba_player_stats}()},
\code{\link{espn_wnba_scoreboard}()},
\code{\link{espn_wnba_standings}()},
\code{\link{espn_wnba_team_box}()},
\code{\link{espn_wnba_team_stats}()},
\code{\link{espn_wnba_teams}()}
}
\author{
Saiem Gilani
}
\concept{ESPN WNBA Functions}
\keyword{Game}
\keyword{Roster}
\keyword{WNBA}
