% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.weightfunct.R
\name{predict}
\alias{predict}
\title{Predicted Values for 'weightfunct' Objects}
\usage{
predict(x, values = NULL, ...)
}
\arguments{
\item{x}{an object of class weightfunct}

\item{values}{a vector or matrix specifying the values of the moderator variables for which predicted values should be calculated; defaults to \code{NULL}}

\item{...}{other arguments}
}
\value{
The function returns a list containing the following components: \code{unadjusted}, \code{adjusted}, and \code{values}. The \code{values} section simply prints the \code{values} matrix for verification. The \code{unadjusted} and \code{adjusted} sections print the conditional means for each row of new data, unadjusted and adjusted for publication bias (respectively), and their standard errors.
}
\description{
This function calculates predicted conditional means and their corresponding standard errors for objects of class weightfunct.
}
\details{
\code{predict(x)} requires that the user specify a vector or matrix of predictor values. Without specifying values, the function will not work.

For models including \code{y} number of moderator variables, users should set \code{values} equal to a \code{k} x \code{y} matrix, where \code{k} is the number of rows of data (i.e., "new" studies). In the example code, for example, there are 3 moderator variables and one row of data, so \code{values} is a 1 x 3 matrix. The intercept is incldued by default.

Note that \code{weightfunct} handles categorical moderators automatically. To include them here, the appropriate contrast (dummy) variables must be explicitly specified. The \code{contrasts} function can help to understand the contrast matrix for a given factor.
}
\examples{
\dontrun{
test <- weightfunct(effect, v, steps)
values <- matrix(c(0,1,0),ncol=3) # An arbitrary set of 3 dummy-coded moderators
predict(test, values)
}
}
\keyword{weightr}
