% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lof_scores.R
\name{glosh_scores}
\alias{glosh_scores}
\title{GLOSH scores}
\usage{
glosh_scores(y, k = 10, ...)
}
\arguments{
\item{y}{Numerical matrix or vector of data}

\item{k}{Minimum cluster size. Default: 5.}

\item{...}{Additional arguments passed to \code{dbscan::\link[dbscan]{hdbscan}}}
}
\value{
Numerical vector containing GLOSH values
}
\description{
Compute Global-Local Outlier Score from Hierarchies. This is based
on hierarchical clustering where the minimum cluster size is k. The resulting
outlier score is a measure of how anomalous each observation is.
The function uses \code{dbscan::\link[dbscan]{hdbscan}} to do the calculation.
}
\examples{
y <- c(rnorm(49), 5)
glosh_scores(y)
}
\seealso{
\code{dbscan::\link[dbscan]{glosh}}
}
\author{
Rob J Hyndman
}
