% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/geometrycollection.R
\name{geometrycollection}
\alias{geometrycollection}
\title{Make WKT geometrycollection objects}
\usage{
geometrycollection(...)
}
\arguments{
\item{...}{Character string WKT objects representing a Point, LineString,
Polygon, etc.}
}
\description{
Make WKT geometrycollection objects
}
\details{
This is different from the other functions that create WKT from R
objects, in that we can't do the same thing for GeometryCollection's since
many different WkT object could be created from the same input. So,
this function accepts WKT strings already formed and attempts to creat a c
GeommetryCollection from them.
}
\examples{
## empty geometrycollection
geometrycollection("empty")
# geometrycollection("stuff")

# Character string, returns itself
geometrycollection("GEOMETRYCOLLECTION(POINT(4 6), LINESTRING(4 6, 7 10))")

# From a point
geometrycollection(point(-116.4, 45.2))

# From two points
geometrycollection(point(-116.4, 45.2), point(-118.4, 49.2))

# From various object types
geometrycollection(point(-116.4, 45.2),
 linestring("LINESTRING (-116.4 45.2, -118.0 47.0)"),
 circularstring(list(c(1, 5), c(6, 2), c(7, 3)), fmt = 2)
)
}
\seealso{
Other R.objects: \code{\link{circularstring}};
  \code{\link{linestring}}; \code{\link{multilinestring}};
  \code{\link{multipoint}}; \code{\link{multipolygon}};
  \code{\link{point}}; \code{\link{polygon}}
}

