% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdists.R
\name{Wdensities}
\alias{Wdensities}
\title{Compute densities of weights of evidence in cases and controls}
\usage{
Wdensities(y, posterior.p, prior.p, range.xseq = c(-25, 25),
  x.stepsize = 0.01, adjust.bw = 1, in.spike = NULL)
}
\arguments{
\item{y}{Binary outcome label (0 for controls, 1 for cases).}

\item{posterior.p}{Vector of posterior probabilities generated by using model
to predict on test data.}

\item{prior.p}{Vector of prior probabilities.}

\item{range.xseq}{Range of points where the curves should be sampled.}

\item{x.stepsize}{Distance between each point.}

\item{adjust.bw}{Bandwidth adjustment for the Gaussian kernel density
estimator. By default it's set to 1 (no adjustment), setting it to
a value smaller/larger than 1 reduces/increases the smoothing of
the kernel. This argument is ignored if \code{in.spike} is not
\code{NULL}.}

\item{in.spike}{If \code{NULL}, the distributions of the weights of evidence
are assumed to be approximately gaussian. If instead a spike-slab
mixture distribution should be assumed, the this must be a logical
vector of the same length as \code{y}, with elements set to \code{TRUE}
if in the spike component, \code{FALSE} otherwise. Typically used
where high proportion of values of the predictor are zero.}
}
\value{
A densities object that contains the information necessary to compute
summary measures and generate plots.
}
\description{
The function computes smoothed densities of the weight of evidence in
cases and in controls from the crude probabilities, then adjusts them to
make them mathematically consistent.
}
\details{
If the model probabilities reflect a spike-slab mixture distribution, where
a high proportion of values of the predictor are zero, these can be
indicated through the \code{in.spike} argument. In the general case, it's
fine to leave it set to \code{NULL}.
}
\examples{
data("cleveland")
densities <- with(cleveland, Wdensities(y, posterior.p, prior.p))

# Example which requires fitting a mixture distribution
data("fitonly")
densities <- with(fitonly, Wdensities(y, posterior.p, prior.p,
                                      in.spike=posterior.p < 0.1))

}
