% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_flow_accumulation_full_workflow}
\alias{wbt_flow_accumulation_full_workflow}
\title{Flow accumulation full workflow}
\usage{
wbt_flow_accumulation_full_workflow(
  dem,
  out_dem,
  out_pntr,
  out_accum,
  out_type = "Specific Contributing Area",
  log = FALSE,
  clip = FALSE,
  esri_pntr = FALSE,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{out_dem}{Output raster DEM file.}

\item{out_pntr}{Output raster flow pointer file.}

\item{out_accum}{Output raster flow accumulation file.}

\item{out_type}{Output type; one of 'cells', 'sca' (default), and 'ca'.}

\item{log}{Optional flag to request the output be log-transformed.}

\item{clip}{Optional flag to request clipping the display max by 1 percent.}

\item{esri_pntr}{D8 pointer uses the ESRI style scheme.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Resolves all of the depressions in a DEM, outputting a breached DEM, an aspect-aligned non-divergent flow pointer, and a flow accumulation raster.
}
