% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_classify_overlap_points}
\alias{wbt_classify_overlap_points}
\title{Classify overlap points}
\usage{
wbt_classify_overlap_points(
  input,
  output,
  resolution = 2,
  criterion = "max scan angle",
  filter = FALSE,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input LiDAR file.}

\item{output}{Output LiDAR file.}

\item{resolution}{The size of the square area used to evaluate nearby points in the LiDAR data.}

\item{criterion}{Criterion used to identify overlapping points; options are 'max scan angle', 'not min point source ID', 'not min time', 'multiple point source IDs'.}

\item{filter}{Filter out points from overlapping flightlines? If false, overlaps will simply be classified.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Classifies or filters LAS points in regions of overlapping flight lines.
}
\keyword{LiDARTools}
