% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_contours_from_points}
\alias{wbt_contours_from_points}
\title{Contours from points}
\usage{
wbt_contours_from_points(
  input,
  output,
  field = NULL,
  use_z = FALSE,
  max_triangle_edge_length = NULL,
  interval = 10,
  base = 0,
  smooth = 5,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input vector points file.}

\item{output}{Output vector lines file.}

\item{field}{Input field name in attribute table.}

\item{use_z}{Use the 'z' dimension of the Shapefile's geometry instead of an attribute field?.}

\item{max_triangle_edge_length}{Optional maximum triangle edge length; triangles larger than this size will not be gridded.}

\item{interval}{Contour interval.}

\item{base}{Base contour height.}

\item{smooth}{Smoothing filter size (in num. points), e.g. 3, 5, 7, 9, 11.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Creates a contour coverage from a set of input points.
}
\keyword{GeomorphometricAnalysis}
