% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_lidar_info}
\alias{wbt_lidar_info}
\title{Lidar info}
\usage{
wbt_lidar_info(
  input,
  output,
  density = TRUE,
  vlr = TRUE,
  geokeys = TRUE,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input LiDAR file.}

\item{output}{Output HTML file for summary report.}

\item{density}{Flag indicating whether or not to calculate the average point density and nominal point spacing.}

\item{vlr}{Flag indicating whether or not to print the variable length records (VLRs).}

\item{geokeys}{Flag indicating whether or not to print the geokeys.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Prints information about a LiDAR (LAS) dataset, including header, point return frequency, and classification data and information about the variable length records (VLRs) and geokeys.
}
\keyword{LiDARTools}
